/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.piccolophet.PhetTabbedPane;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.LWJGLPhetApplication;
import edu.colorado.phet.lwjglphet.StartupUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.control.MoleculeShapesTeacherMenu;
import edu.colorado.phet.moleculeshapes.dev.DeveloperOptions;
import edu.colorado.phet.moleculeshapes.tabs.moleculeshapes.MoleculeShapesTab;
import edu.colorado.phet.moleculeshapes.tabs.realmolecules.RealMoleculesTab;
import java.io.IOException;
import javax.swing.JMenu;

public class MoleculeShapesBasicsApplication
extends LWJGLPhetApplication {
    private static final Property<Boolean> whiteBackground = new Property<Boolean>(false);

    public MoleculeShapesBasicsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        final LWJGLCanvas lWJGLCanvas = LWJGLCanvas.getCanvasInstance(phetFrame);
        this.addModule(new PhetTabbedPane.TabbedModule(lWJGLCanvas){
            {
                super(component);
                this.addTab(new MoleculeShapesTab(lWJGLCanvas, MoleculeShapesResources.Strings.MOLECULE__SHAPES__BASICS__TITLE, true));
                this.addTab(new RealMoleculesTab(lWJGLCanvas, MoleculeShapesResources.Strings.REAL__MOLECULES, false, true));
            }
        });
    }

    private void initMenubar() {
        PhetFrame phetFrame = this.getPhetFrame();
        OptionsMenu optionsMenu = new OptionsMenu();
        if (optionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
        phetFrame.addMenu(new MoleculeShapesTeacherMenu(whiteBackground));
        JMenu jMenu = phetFrame.getDeveloperMenu();
        DeveloperOptions.addDeveloperOptions(jMenu, phetFrame);
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        try {
            StartupUtils.setupLibraries();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        MoleculeShapesColor.switchToBasicColors();
        new PhetApplicationLauncher().launchSim(stringArray, "molecule-shapes", "molecule-shapes-basics", MoleculeShapesBasicsApplication.class);
    }
}

