/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.control;

import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.colorado.phet.lwjglphet.LWJGLCursorHandler;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.MoleculeShapesSimSharing;
import edu.colorado.phet.moleculeshapes.model.Bond;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.tabs.moleculeshapes.MoleculeShapesControlPanel;
import edu.colorado.phet.moleculeshapes.tabs.moleculeshapes.MoleculeShapesTab;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BondTypeControlNode
extends PNode {
    private final MoleculeShapesTab module;
    private final PNode graphic;
    private final int bondOrder;
    private final Property<Boolean> enabled;
    private final PNode removeButton;
    protected boolean showingRemoveButton = false;

    public BondTypeControlNode(final MoleculeShapesTab moleculeShapesTab, PNode pNode, final int n, final Property<Boolean> property) {
        this.module = moleculeShapesTab;
        this.graphic = pNode;
        this.bondOrder = n;
        this.enabled = property;
        this.addChild(pNode);
        pNode.addChild(0, new Spacer(pNode.getFullBounds()));
        this.removeButton = new PImage(MoleculeShapesResources.Images.REMOVE);
        this.removeButton.setOffset(MoleculeShapesControlPanel.INNER_WIDTH - this.removeButton.getFullBounds().getWidth(), (pNode.getFullBounds().getHeight() - this.removeButton.getFullBounds().getHeight()) / 2.0);
        this.addChild(this.removeButton);
        pNode.setOffset((MoleculeShapesControlPanel.INNER_WIDTH - this.removeButton.getFullBounds().getWidth() - pNode.getFullBounds().getWidth()) / 2.0, 0.0);
        this.removeButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseClicked(PInputEvent pInputEvent) {
                LWJGLUtils.invoke(new Runnable(){

                    public void run() {
                        PairGroup pairGroup = BondTypeControlNode.this.getLastMatchingGroup();
                        if (pairGroup != null) {
                            moleculeShapesTab.getMolecule().removeGroup(pairGroup);
                            SimSharingManager.sendUserMessage(MoleculeShapesSimSharing.UserComponents.bond, UserComponentTypes.sprite, MoleculeShapesSimSharing.Actions.removed, ParameterSet.parameterSet((IParameterKey)MoleculeShapesSimSharing.ParamKeys.bondOrder, n));
                            BondTypeControlNode.systemResponseForGeometries(moleculeShapesTab.getMolecule());
                        }
                    }
                });
            }
        });
        moleculeShapesTab.getMolecule().onBondChanged.addUpdateListener(new UpdateListener(){

            public void update() {
                BondTypeControlNode.this.updateState();
            }
        }, true);
        pNode.addInputEventListener(new LWJGLCursorHandler(){

            public boolean isEnabled() {
                return (Boolean)property.get();
            }
        });
        this.removeButton.addInputEventListener(new LWJGLCursorHandler(){

            public boolean isEnabled() {
                return BondTypeControlNode.this.showingRemoveButton;
            }
        });
        this.addDragEvent(new Runnable(){

            public void run() {
                moleculeShapesTab.startNewInstanceDrag(n);
                SimSharingManager.sendUserMessage(MoleculeShapesSimSharing.UserComponents.bond, UserComponentTypes.sprite, MoleculeShapesSimSharing.Actions.created, ParameterSet.parameterSet((IParameterKey)MoleculeShapesSimSharing.ParamKeys.bondOrder, n));
                BondTypeControlNode.systemResponseForGeometries(moleculeShapesTab.getMolecule());
            }
        });
    }

    public void addDragEvent(final Runnable runnable) {
        this.graphic.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                if (((Boolean)BondTypeControlNode.this.enabled.get()).booleanValue() && pInputEvent.getButton() == 1) {
                    LWJGLUtils.invoke(runnable);
                }
            }
        });
    }

    public static void systemResponseForGeometries(Molecule molecule) {
        String string = molecule.getCentralVseprConfiguration().geometry.name;
        String string2 = string == null ? MoleculeShapesResources.Strings.GEOMETRY__EMPTY : string;
        String string3 = molecule.getCentralVseprConfiguration().name;
        String string4 = string3 == null ? MoleculeShapesResources.Strings.SHAPE__EMPTY : string3;
        SimSharingManager.sendModelMessage(MoleculeShapesSimSharing.ModelObjects.molecule, ModelComponentTypes.modelElement, MoleculeShapesSimSharing.ModelActions.bondsChanged, ParameterSet.parameterSet((IParameterKey)MoleculeShapesSimSharing.ParamKeys.electronGeometry, string2).with((IParameterKey)MoleculeShapesSimSharing.ParamKeys.moleculeGeometry, string4));
    }

    private boolean hasMatchingGroup() {
        return this.getLastMatchingGroup() != null;
    }

    private PairGroup getLastMatchingGroup() {
        Molecule molecule = this.module.getMolecule();
        List<Bond<PairGroup>> list = molecule.getBonds(molecule.getCentralAtom());
        Collections.reverse(list);
        for (Bond<PairGroup> bond : list) {
            if (bond.order != this.bondOrder) continue;
            return bond.getOtherAtom(molecule.getCentralAtom());
        }
        return null;
    }

    protected boolean isEnabled() {
        return this.module.getMolecule().wouldAllowBondOrder(this.bondOrder);
    }

    protected void updateState() {
        this.enabled.set(this.isEnabled());
        this.showingRemoveButton = this.hasMatchingGroup();
        this.graphic.setTransparency(this.enabled.get() != false ? 1.0f : 0.7f);
        this.removeButton.setVisible(this.showingRemoveButton);
    }

    public PNode getGraphic() {
        return this.graphic;
    }
}

