/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.control;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.materials.ColorMaterial;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.shapes.Quad;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.tabs.MoleculeViewTab;
import edu.colorado.phet.moleculeshapes.view.MoleculeModelNode;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BondTypeOverlayNode
extends MoleculeModelNode {
    public BondTypeOverlayNode(Molecule molecule, MoleculeViewTab moleculeViewTab, final Property<Boolean> property) {
        super(molecule, new GLNode(), moleculeViewTab);
        this.setScaleOverride(1.0f);
        this.getCenterAtomNode().setVisible(false);
        final boolean bl = !molecule.getRadialLonePairs().isEmpty();
        float f = (float)((bl ? 7.0 : 10.0) + 2.0);
        final float f2 = 0.4f * (float)(bl ? 13 : 10);
        final Quad quad = new Quad(f, f2){
            {
                super(f, f22);
                this.translate(0.0f, -f2 / 2.0f, 0.4f * (float)(bl ? 8 : 5));
                MoleculeShapesColor.BACKGROUND.addLWJGLColorObserver(new VoidFunction1<Color>(){

                    @Override
                    public void apply(Color color) {
                        float[] fArray = color.getColorComponents(new float[4]);
                        float f = 0.3f + fArray[0] + fArray[1] + fArray[2] * 0.3f / 3.0f;
                        this.setMaterial(new ColorMaterial(fArray[0], fArray[1], fArray[2], (float)MathUtil.clamp(0.0, f, 1.0)));
                    }
                });
                this.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
                this.requireEnabled(3042);
            }
        };
        this.addChild(quad);
        property.addObserver(new SimpleObserver(){

            public void update() {
                quad.setVisible((Boolean)property.get() == false);
            }
        });
    }
}

