/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.math.Permutation;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.moleculeshapes.model.AttractorModel;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.model.RealPairGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalShape {
    private final PairGroup centralAtom;
    private final List<PairGroup> groups;
    private final List<Vector3D> idealOrientations;
    private final List<Permutation> allowedPermutations;

    public LocalShape(List<Permutation> list, PairGroup pairGroup, List<PairGroup> list2, List<Vector3D> list3) {
        this.allowedPermutations = list;
        this.centralAtom = pairGroup;
        this.groups = list2;
        this.idealOrientations = list3;
    }

    public double applyAttraction(float f) {
        return AttractorModel.applyAttractorForces(this.groups, f, this.idealOrientations, this.allowedPermutations, this.centralAtom.position.get(), false);
    }

    public static List<Permutation> permuteListWithIndices(List<Permutation> list, List<Integer> list2) {
        if (list2.size() < 2) {
            return list;
        }
        ArrayList<Permutation> arrayList = new ArrayList<Permutation>();
        for (Permutation permutation : list) {
            arrayList.addAll(permutation.withIndicesPermuted(list2));
        }
        return arrayList;
    }

    public static List<PairGroup> sortedLonePairsFirst(List<PairGroup> list) {
        ArrayList<PairGroup> arrayList = new ArrayList<PairGroup>(list);
        Collections.sort(arrayList, new Comparator<PairGroup>(){

            @Override
            public int compare(PairGroup pairGroup, PairGroup pairGroup2) {
                if (pairGroup.isLonePair == pairGroup2.isLonePair) {
                    return 0;
                }
                if (pairGroup.isLonePair) {
                    return -1;
                }
                return 1;
            }
        });
        return arrayList;
    }

    public static List<Permutation> vseprPermutations(final List<PairGroup> list) {
        List<Permutation> list2 = new ArrayList<Permutation>();
        list2.add(Permutation.identity(list.size()));
        Function1<PairGroup, Integer> function1 = new Function1<PairGroup, Integer>(){

            @Override
            public Integer apply(PairGroup pairGroup) {
                return list.indexOf(pairGroup);
            }
        };
        Pair<List<PairGroup>, List<PairGroup>> pair = FunctionalUtils.partition(list, new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return pairGroup.isLonePair;
            }
        });
        List list3 = (List)pair._1;
        List list4 = (List)pair._2;
        list2 = LocalShape.permuteListWithIndices(list2, FunctionalUtils.map(list3, function1));
        list2 = LocalShape.permuteListWithIndices(list2, FunctionalUtils.map(list4, function1));
        return list2;
    }

    public static List<Permutation> realPermutations(final List<PairGroup> list) {
        List<Permutation> list2 = new ArrayList<Permutation>();
        list2.add(Permutation.identity(list.size()));
        Function1<PairGroup, Integer> function1 = new Function1<PairGroup, Integer>(){

            @Override
            public Integer apply(PairGroup pairGroup) {
                return list.indexOf(pairGroup);
            }
        };
        List<PairGroup> list3 = FunctionalUtils.filter(list, new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return pairGroup.isLonePair;
            }
        });
        list2 = LocalShape.permuteListWithIndices(list2, FunctionalUtils.map(list3, function1));
        List<RealPairGroup> list4 = FunctionalUtils.map(FunctionalUtils.filter(list, new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return !pairGroup.isLonePair;
            }
        }), new Function1<PairGroup, RealPairGroup>(){

            @Override
            public RealPairGroup apply(PairGroup pairGroup) {
                return (RealPairGroup)pairGroup;
            }
        });
        List<Element> list5 = FunctionalUtils.unique(FunctionalUtils.map(list4, new Function1<RealPairGroup, Element>(){

            @Override
            public Element apply(RealPairGroup realPairGroup) {
                return realPairGroup.getElement();
            }
        }));
        for (final Element element : list5) {
            List<RealPairGroup> list6 = FunctionalUtils.filter(list4, new Function1<RealPairGroup, Boolean>(){

                @Override
                public Boolean apply(RealPairGroup realPairGroup) {
                    return realPairGroup.getElement() == element;
                }
            });
            list2 = LocalShape.permuteListWithIndices(list2, FunctionalUtils.map(list6, function1));
        }
        return list2;
    }

    public void applyAngleAttractionRepulsion(float f) {
        AttractorModel.applyAttractorForces(this.groups, f, this.idealOrientations, this.allowedPermutations, this.centralAtom.position.get(), true);
    }
}

