/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.moleculeshapes.model.LocalShape;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSEPRMolecule
extends Molecule {
    private final double bondLengthOverride;
    private final boolean useBondLengthOverride;

    public VSEPRMolecule() {
        this.bondLengthOverride = 0.0;
        this.useBondLengthOverride = false;
    }

    public LocalShape getLocalShape(PairGroup pairGroup) {
        return this.getLocalVSEPRShape(pairGroup);
    }

    @Override
    public void update(float f) {
        super.update(f);
        List<PairGroup> list = this.getRadialGroups();
        for (PairGroup pairGroup : this.getAtoms()) {
            if (this.getNeighbors(pairGroup).size() <= 1) continue;
            if (pairGroup.isCentralAtom()) {
                double d = this.getLocalShape(pairGroup).applyAttraction(f);
                double d2 = Math.max(0.0, Math.min(1.0, Math.log(d + 1.0) - 0.5));
                for (PairGroup pairGroup2 : list) {
                    for (PairGroup pairGroup3 : list) {
                        if (pairGroup3 == pairGroup2 || pairGroup2 == this.getCentralAtom()) continue;
                        pairGroup2.repulseFrom(pairGroup3, f, d2);
                    }
                }
                continue;
            }
            this.getLocalShape(pairGroup).applyAngleAttractionRepulsion(f);
        }
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public Option<Float> getMaximumBondLength() {
        if (this.useBondLengthOverride) {
            return new Option.Some<Float>(Float.valueOf((float)this.bondLengthOverride));
        }
        return new Option.Some<Float>(Float.valueOf(10.0f));
    }
}

