/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.tabs.moleculeshapes;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.lwjglphet.utils.GLActionListener;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.MoleculeShapesConstants;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.control.BondTypeControlNode;
import edu.colorado.phet.moleculeshapes.control.MoleculeShapesPanelNode;
import edu.colorado.phet.moleculeshapes.control.OptionsNode;
import edu.colorado.phet.moleculeshapes.control.PropertyCheckBoxNode;
import edu.colorado.phet.moleculeshapes.control.TitledControlPanelNode;
import edu.colorado.phet.moleculeshapes.tabs.moleculeshapes.MoleculeShapesTab;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;

public class MoleculeShapesControlPanel
extends PNode {
    private static final String[] TITLE_STRINGS = new String[]{MoleculeShapesResources.Strings.CONTROL__BONDING, MoleculeShapesResources.Strings.CONTROL__LONE_PAIR, MoleculeShapesResources.Strings.CONTROL__OPTIONS, MoleculeShapesResources.Strings.REAL_EXAMPLES__TITLE};
    private static final String[] CHECKBOX_STRINGS = new String[]{MoleculeShapesResources.Strings.CONTROL__SHOW_BOND_ANGLES, MoleculeShapesResources.Strings.CONTROL__SHOW_LONE_PAIRS};
    public static final double INNER_WIDTH = Math.ceil(MoleculeShapesControlPanel.getRequiredInnerWidth());
    private BondTypeControlNode singleBondNode;
    private BondTypeControlNode doubleBondNode;
    private BondTypeControlNode tripleBondNode;
    private BondTypeControlNode lonePairNode;

    public MoleculeShapesControlPanel(final MoleculeShapesTab moleculeShapesTab) {
        final MoleculeShapesPanelNode moleculeShapesPanelNode = new MoleculeShapesPanelNode(new PNode(){
            {
                this.addChild(new Spacer(0.0, 0.0, INNER_WIDTH, 10.0));
                MoleculeShapesControlPanel.this.singleBondNode = new BondTypeControlNode(moleculeShapesTab, new Spacer(0.0, 0.0, 100.0, 33.0), 1, moleculeShapesTab.addSingleBondEnabled){
                    {
                        this.setOffset(0.0, 10.0);
                    }
                };
                this.addChild(MoleculeShapesControlPanel.this.singleBondNode);
                MoleculeShapesControlPanel.this.doubleBondNode = new BondTypeControlNode(moleculeShapesTab, new Spacer(0.0, 0.0, 100.0, 33.0), 2, moleculeShapesTab.addDoubleBondEnabled){
                    {
                        this.setOffset(0.0, MoleculeShapesControlPanel.this.singleBondNode.getFullBounds().getMaxY() + 8.0);
                    }
                };
                this.addChild(MoleculeShapesControlPanel.this.doubleBondNode);
                MoleculeShapesControlPanel.this.tripleBondNode = new BondTypeControlNode(moleculeShapesTab, new Spacer(0.0, 0.0, 100.0, 33.0), 3, moleculeShapesTab.addTripleBondEnabled){
                    {
                        this.setOffset(0.0, MoleculeShapesControlPanel.this.doubleBondNode.getFullBounds().getMaxY() + 8.0);
                    }
                };
                this.addChild(MoleculeShapesControlPanel.this.tripleBondNode);
            }
        }, MoleculeShapesResources.Strings.CONTROL__BONDING);
        this.addChild(moleculeShapesPanelNode);
        this.setOffset(0.0, 10.0);
        MoleculeShapesPanelNode moleculeShapesPanelNode2 = new MoleculeShapesPanelNode(new PNode(){
            {
                this.addChild(new Spacer(0.0, 0.0, INNER_WIDTH, 10.0));
                MoleculeShapesControlPanel.this.lonePairNode = new BondTypeControlNode(moleculeShapesTab, new Spacer(0.0, 0.0, 61.0, 42.0), 0, moleculeShapesTab.addLonePairEnabled){
                    {
                        this.setOffset(0.0, 10.0);
                        moleculeShapesTab.showLonePairs.addObserver(LWJGLUtils.swingObserver(new Runnable(){

                            public void run() {
                                this.updateState();
                            }
                        }), false);
                    }

                    protected boolean isEnabled() {
                        return super.isEnabled() && (Boolean)moleculeShapesTab.showLonePairs.get() != false;
                    }
                };
                this.addChild(MoleculeShapesControlPanel.this.lonePairNode);
            }
        }, MoleculeShapesResources.Strings.CONTROL__LONE_PAIR){
            {
                super(pNode, string);
                this.setOffset(0.0, moleculeShapesPanelNode.getFullBounds().getMaxY() + 20.0);
            }
        };
        if (!moleculeShapesTab.isBasicsVersion()) {
            this.addChild(moleculeShapesPanelNode2);
        }
        final PBounds pBounds = moleculeShapesTab.isBasicsVersion() ? moleculeShapesPanelNode.getFullBounds() : moleculeShapesPanelNode2.getFullBounds();
        TextButtonNode textButtonNode = new TextButtonNode(MoleculeShapesResources.Strings.CONTROL__REMOVE_ALL, MoleculeShapesConstants.REMOVE_BUTTON_FONT, MoleculeShapesColor.REMOVE_BUTTON_BACKGROUND.get()){
            {
                super(string, font, color);
                this.addActionListener(new GLActionListener(new Runnable(){

                    public void run() {
                        moleculeShapesTab.getMolecule().removeAllGroups();
                        BondTypeControlNode.systemResponseForGeometries(moleculeShapesTab.getMolecule());
                    }
                }));
                MoleculeShapesColor.REMOVE_BUTTON_BACKGROUND.addColorObserver(new VoidFunction1<Color>(){

                    @Override
                    public void apply(Color color) {
                        this.setBackground(color);
                    }
                });
                MoleculeShapesColor.REMOVE_BUTTON_TEXT.addColorObserver(new VoidFunction1<Color>(){

                    @Override
                    public void apply(Color color) {
                        this.setEnabledTextColor(color);
                    }
                });
                this.setOffset((pBounds.getWidth() - this.getFullBounds().getWidth()) / 2.0, pBounds.getMaxY() + 20.0 - 4.0);
            }
        };
        this.addChild(textButtonNode);
        MoleculeShapesPanelNode moleculeShapesPanelNode3 = new MoleculeShapesPanelNode((PNode)new OptionsNode(moleculeShapesTab, INNER_WIDTH), MoleculeShapesResources.Strings.CONTROL__OPTIONS);
        moleculeShapesPanelNode3.setOffset(0.0, textButtonNode.getFullBounds().getMaxY() + 30.0);
        this.addChild(moleculeShapesPanelNode3);
    }

    public PBounds getSingleBondTargetBounds() {
        return this.singleBondNode.getGraphic().getGlobalFullBounds();
    }

    public PBounds getDoubleBondTargetBounds() {
        return this.doubleBondNode.getGraphic().getGlobalFullBounds();
    }

    public PBounds getTripleBondTargetBounds() {
        return this.tripleBondNode.getGraphic().getGlobalFullBounds();
    }

    public PBounds getLonePairTargetBounds() {
        return this.lonePairNode.getGraphic().getGlobalFullBounds();
    }

    public static double getRequiredInnerWidth() {
        double d = 160.0;
        for (String string : TITLE_STRINGS) {
            double d2 = new TitledControlPanelNode.TitleNode(string).getFullBounds().getWidth();
            d2 = string.equals(MoleculeShapesResources.Strings.REAL_EXAMPLES__TITLE) ? (d2 += 45.0) : (d2 += 25.0);
            d = Math.max(d, d2);
        }
        for (String string : CHECKBOX_STRINGS) {
            d = Math.max(d, new PropertyCheckBoxNode(new UserComponent("dummy"), string, new Property<Boolean>(true)).getFullBounds().getWidth());
        }
        return d;
    }
}

