/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.tabs.moleculeshapes;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.QuaternionF;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.nodes.GuiNode;
import edu.colorado.phet.lwjglphet.nodes.OrthoPiccoloNode;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.MoleculeShapesSimSharing;
import edu.colorado.phet.moleculeshapes.control.BondTypeOverlayNode;
import edu.colorado.phet.moleculeshapes.control.GeometryNameNode;
import edu.colorado.phet.moleculeshapes.control.MoleculeShapesPanelNode;
import edu.colorado.phet.moleculeshapes.model.Bond;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.model.VSEPRMolecule;
import edu.colorado.phet.moleculeshapes.tabs.MoleculeViewTab;
import edu.colorado.phet.moleculeshapes.tabs.moleculeshapes.MoleculeShapesControlPanel;
import edu.colorado.phet.moleculeshapes.view.LonePairNode;
import edu.colorado.phet.moleculeshapes.view.MoleculeModelNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class MoleculeShapesTab
extends MoleculeViewTab {
    private final boolean isBasicsVersion;
    public final Property<Boolean> addSingleBondEnabled = new Property<Boolean>(true);
    public final Property<Boolean> addDoubleBondEnabled = new Property<Boolean>(true);
    public final Property<Boolean> addTripleBondEnabled = new Property<Boolean>(true);
    public final Property<Boolean> addLonePairEnabled = new Property<Boolean>(true);
    private Property<Rectangle2D> realMoleculeOverlayStageBounds = new Property<PBounds>(new PBounds(0.0, 0.0, 1.0, 1.0));
    private Property<Rectangle2D> singleBondOverlayStageBounds;
    private Property<Rectangle2D> doubleBondOverlayStageBounds;
    private Property<Rectangle2D> tripleBondOverlayStageBounds;
    private Property<Rectangle2D> lonePairOverlayStageBounds;
    private OrthoPiccoloNode controlPanel;
    private OrthoPiccoloNode namePanel;
    private MoleculeShapesControlPanel controlPanelNode;
    private static final Random random = new Random(System.currentTimeMillis());

    public MoleculeShapesTab(LWJGLCanvas lWJGLCanvas, String string, boolean bl) {
        super(lWJGLCanvas, string);
        this.isBasicsVersion = bl;
        this.setMolecule(new VSEPRMolecule());
    }

    public void initialize() {
        Object object;
        super.initialize();
        this.initializeResources();
        this.getMolecule().onBondChanged.addListener(new VoidFunction1<Bond<PairGroup>>(){

            @Override
            public void apply(Bond<PairGroup> bond) {
                if (MoleculeShapesTab.this.getMolecule().getRadialLonePairs().isEmpty()) {
                    MoleculeShapesTab.this.showLonePairs.set(true);
                }
            }
        });
        this.moleculeNode = new MoleculeModelNode(this.getMolecule(), this.readoutLayer, this);
        this.sceneLayer.addChild(this.moleculeNode);
        PairGroup pairGroup = new PairGroup(new Vector3D(), false, false);
        this.getMolecule().addCentralAtom(pairGroup);
        this.getMolecule().addGroup(new PairGroup(new Vector3D(8.0, 0.0, 3.0).normalized().times(10.0), false, false), pairGroup, 1);
        Vector3D vector3D = new Vector3D(2.0, 8.0, -5.0);
        this.getMolecule().addGroup(new PairGroup(vector3D.normalized().times(10.0), false, false), pairGroup, 1);
        this.singleBondOverlayStageBounds = new Property<PBounds>(new PBounds(0.0, 0.0, this.getStageSize().width, this.getStageSize().height));
        this.doubleBondOverlayStageBounds = new Property<PBounds>(new PBounds(0.0, 0.0, this.getStageSize().width, this.getStageSize().height));
        this.tripleBondOverlayStageBounds = new Property<PBounds>(new PBounds(0.0, 0.0, this.getStageSize().width, this.getStageSize().height));
        this.lonePairOverlayStageBounds = new Property<PBounds>(new PBounds(0.0, 0.0, this.getStageSize().width, this.getStageSize().height));
        Function2<String, Property<Rectangle2D>, GLNode> function2 = new Function2<String, Property<Rectangle2D>, GLNode>(){

            @Override
            public GLNode apply(String string, final Property<Rectangle2D> property) {
                return new GuiNode(MoleculeShapesTab.this){
                    private LWJGLTransform projectionTransform;
                    {
                        super(lWJGLTab);
                        this.projectionTransform = new LWJGLTransform();
                        this.requireEnabled(2929);
                        this.requireEnabled(3042);
                        this.addResetAttrib(2048);
                    }

                    protected void preRender(GLOptions gLOptions) {
                        super.preRender(gLOptions);
                        Rectangle2D rectangle2D = MoleculeShapesTab.this.canvasTransform.getTransformedBounds((Rectangle2D)property.get());
                        GL11.glViewport((int)rectangle2D.getMinX(), (int)((double)MoleculeShapesTab.this.getCanvasHeight() - rectangle2D.getMaxY()), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                        GL11.glMatrixMode(5889);
                        GL11.glLoadIdentity();
                        float f = 0.38397244f;
                        float f2 = (float)Math.atan(Math.tan(f));
                        Matrix4F matrix4F = MoleculeShapesTab.this.getGluPerspective(f2, (float)(((Rectangle2D)property.get()).getWidth() / ((Rectangle2D)property.get()).getHeight()), 1.0f, 1000.0f);
                        this.projectionTransform.set(matrix4F);
                        this.projectionTransform.apply();
                        GL11.glMatrixMode(5888);
                        GL11.glLoadIdentity();
                        GL11.glTranslatef(0.0f, 0.0f, -45.0f);
                        MoleculeShapesTab.this.loadLighting();
                    }
                };
            }
        };
        GLNode gLNode = (GLNode)function2.apply("Single Bond", this.singleBondOverlayStageBounds);
        gLNode.addChild(new BondTypeOverlayNode((Molecule)new VSEPRMolecule(){
            {
                PairGroup pairGroup = new PairGroup(new Vector3D(), false, false);
                this.addCentralAtom(pairGroup);
                this.addGroup(new PairGroup(Vector3D.X_UNIT.times(10.0), false, false), pairGroup, 1);
            }
        }, this, this.addSingleBondEnabled));
        this.overlayLayer.addChild(gLNode);
        GLNode gLNode2 = (GLNode)function2.apply("Double Bond", this.doubleBondOverlayStageBounds);
        gLNode2.addChild(new BondTypeOverlayNode((Molecule)new VSEPRMolecule(){
            {
                PairGroup pairGroup = new PairGroup(new Vector3D(), false, false);
                this.addCentralAtom(pairGroup);
                this.addGroup(new PairGroup(Vector3D.X_UNIT.times(10.0), false, false), pairGroup, 2);
            }
        }, this, this.addDoubleBondEnabled));
        this.overlayLayer.addChild(gLNode2);
        GLNode gLNode3 = (GLNode)function2.apply("Triple Bond", this.tripleBondOverlayStageBounds);
        gLNode3.addChild(new BondTypeOverlayNode((Molecule)new VSEPRMolecule(){
            {
                PairGroup pairGroup = new PairGroup(new Vector3D(), false, false);
                this.addCentralAtom(pairGroup);
                this.addGroup(new PairGroup(Vector3D.X_UNIT.times(10.0), false, false), pairGroup, 3);
            }
        }, this, this.addTripleBondEnabled));
        this.overlayLayer.addChild(gLNode3);
        if (!this.isBasicsVersion()) {
            object = (GLNode)function2.apply("Lone Pair", this.lonePairOverlayStageBounds);
            ((GLNode)object).addChild(new BondTypeOverlayNode((Molecule)new VSEPRMolecule(){
                {
                    PairGroup pairGroup = new PairGroup(new Vector3D(), false, false);
                    this.addCentralAtom(pairGroup);
                    this.addGroup(new PairGroup(Vector3D.X_UNIT.times(7.0), true, false), pairGroup, 0);
                }
            }, this, this.addLonePairEnabled));
            this.overlayLayer.addChild((GLNode)object);
        }
        object = new Property<Vector2D>(new Vector2D());
        this.controlPanelNode = new MoleculeShapesControlPanel(this);
        this.controlPanel = new OrthoPiccoloNode(this.controlPanelNode, this, this.canvasTransform, (Property)object, this.mouseEventNotifier){
            {
                this.updateOnEvent(MoleculeShapesTab.this.beforeFrameRender);
            }
        };
        this.guiLayer.addChild(this.controlPanel);
        this.guiNodes.add(this.controlPanel);
        this.controlPanel.onResize.addUpdateListener(new UpdateListener(){

            public void update() {
                if (MoleculeShapesTab.this.controlPanel != null) {
                    ((MoleculeShapesTab)MoleculeShapesTab.this).controlPanel.position.set(new Vector2D((float)(MoleculeShapesTab.this.getStageSize().width - MoleculeShapesTab.this.controlPanel.getComponentWidth()) - 10.0f, 10.0));
                }
                MoleculeShapesTab.this.resizeDirty = true;
            }
        }, true);
        this.namePanel = new OrthoPiccoloNode(new MoleculeShapesPanelNode((PNode)new GeometryNameNode(this.getMoleculeProperty(), !this.isBasicsVersion()), MoleculeShapesResources.Strings.CONTROL__GEOMETRY_NAME){
            {
                this.setOffset(0.0, 10.0);
            }
        }, this, this.canvasTransform, new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                this.updateOnEvent(MoleculeShapesTab.this.beforeFrameRender);
                this.onResize.addUpdateListener(new UpdateListener(){

                    public void update() {
                        position.set(new Vector2D(10.0, MoleculeShapesTab.this.getStageSize().getHeight() - (double)this.getComponentHeight() - 10.0));
                    }
                }, true);
            }
        };
        this.guiLayer.addChild(this.namePanel);
        this.guiNodes.add(this.namePanel);
    }

    public void updateState(float f) {
        this.moleculeNode.transform.set(Matrix4F.translation(new Vector3F(-4.5f, 1.5f, 0.0f)).times(((QuaternionF)this.rotation.get()).toRotationMatrix().toMatrix4f()));
        this.getMolecule().update(f);
        this.moleculeNode.updateView();
        if (this.resizeDirty && this.controlPanel != null) {
            this.resizeDirty = false;
            double d = this.getStageSize().getWidth() / 2.3;
            double d2 = this.getStageSize().getHeight() / 2.3;
            Rectangle2D rectangle2D = this.controlPanel.transformBoundsToStage(this.controlPanelNode.getSingleBondTargetBounds());
            Rectangle2D rectangle2D2 = this.controlPanel.transformBoundsToStage(this.controlPanelNode.getDoubleBondTargetBounds());
            Rectangle2D rectangle2D3 = this.controlPanel.transformBoundsToStage(this.controlPanelNode.getTripleBondTargetBounds());
            Rectangle2D rectangle2D4 = this.controlPanel.transformBoundsToStage(this.controlPanelNode.getLonePairTargetBounds());
            this.singleBondOverlayStageBounds.set(new PBounds(rectangle2D.getMinX() - d / 2.0, rectangle2D.getCenterY() - d2 / 2.0, d, d2));
            this.doubleBondOverlayStageBounds.set(new PBounds(rectangle2D2.getMinX() - d / 2.0, rectangle2D2.getCenterY() - d2 / 2.0, d, d2));
            this.tripleBondOverlayStageBounds.set(new PBounds(rectangle2D3.getMinX() - d / 2.0, rectangle2D3.getCenterY() - d2 / 2.0, d, d2));
            this.lonePairOverlayStageBounds.set(new PBounds(rectangle2D4.getMinX() - d / 2.0, rectangle2D4.getCenterY() - d2 / 2.0, d, d2));
        }
    }

    public void startNewInstanceDrag(int n) {
        if (!this.getMolecule().wouldAllowBondOrder(n)) {
            return;
        }
        Vector3F vector3F = this.getPlanarMoleculeCursorPosition();
        PairGroup pairGroup = new PairGroup(vector3F.to3D(), n == 0, true);
        this.getMolecule().addGroup(pairGroup, this.getMolecule().getCentralAtom(), n, (n == 0 ? 7.0 : 10.0) / 5.5);
        this.dragging = true;
        this.dragMode = MoleculeViewTab.DragMode.PAIR_FRESH_PLANAR;
        this.draggedParticle = pairGroup;
        if (!this.globalLeftMouseDown) {
            this.onLeftMouseUp();
        }
        this.draggingChanged();
    }

    private void initializeResources() {
        LonePairNode.getGeometry();
    }

    public boolean isBasicsVersion() {
        return this.isBasicsVersion;
    }

    public boolean allowTogglingLonePairs() {
        return !this.isBasicsVersion();
    }

    public boolean allowTogglingAllLonePairs() {
        return false;
    }

    public boolean isRealTab() {
        return false;
    }

    public IUserComponent getUserComponent() {
        return MoleculeShapesSimSharing.UserComponents.moleculeShapesTab;
    }
}

