/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.tabs.realmolecules;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.Permutation;
import edu.colorado.phet.common.phetcommon.math.QuaternionF;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.nodes.OrthoPiccoloNode;
import edu.colorado.phet.moleculeshapes.MoleculeShapesApplication;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.MoleculeShapesSimSharing;
import edu.colorado.phet.moleculeshapes.control.GeometryNameNode;
import edu.colorado.phet.moleculeshapes.control.MoleculeShapesPanelNode;
import edu.colorado.phet.moleculeshapes.control.PropertyRadioButtonNode;
import edu.colorado.phet.moleculeshapes.model.AttractorModel;
import edu.colorado.phet.moleculeshapes.model.Bond;
import edu.colorado.phet.moleculeshapes.model.LocalShape;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.model.RealMolecule;
import edu.colorado.phet.moleculeshapes.model.RealMoleculeShape;
import edu.colorado.phet.moleculeshapes.model.VSEPRMolecule;
import edu.colorado.phet.moleculeshapes.model.VseprConfiguration;
import edu.colorado.phet.moleculeshapes.tabs.MoleculeViewTab;
import edu.colorado.phet.moleculeshapes.tabs.realmolecules.RealMoleculesControlPanel;
import edu.colorado.phet.moleculeshapes.view.LonePairNode;
import edu.colorado.phet.moleculeshapes.view.MoleculeModelNode;
import edu.umd.cs.piccolo.PNode;
import java.util.List;
import java.util.Random;

public class RealMoleculesTab
extends MoleculeViewTab {
    private final boolean useKit;
    private final boolean isBasicsVersion;
    public Property<RealMoleculeShape> realMolecule = new Property<Object>(null);
    public Property<Boolean> showRealView = new Property<Boolean>(true);
    private OrthoPiccoloNode namePanel;
    private OrthoPiccoloNode controlPanel;
    private static final Random random = new Random(System.currentTimeMillis());

    public RealMoleculesTab(LWJGLCanvas lWJGLCanvas, String string, boolean bl, boolean bl2) {
        super(lWJGLCanvas, string);
        this.useKit = bl;
        this.isBasicsVersion = bl2;
        this.realMolecule.addObserver(new SimpleObserver(){

            public void update() {
                if (RealMoleculesTab.this.realMolecule.get() != null) {
                    SimSharingManager.sendModelMessage(MoleculeShapesSimSharing.ModelObjects.molecule, MoleculeShapesSimSharing.ModelComponentTypes.moleculeModel, MoleculeShapesSimSharing.ModelActions.realMoleculeChanged, new ParameterSet(new Parameter((IParameterKey)MoleculeShapesSimSharing.ModelParameterKeys.realMolecule, RealMoleculesTab.this.realMolecule.get().getDisplayName())));
                }
            }
        });
        RealMoleculeShape realMoleculeShape = bl2 ? RealMoleculeShape.TAB_2_BASIC_MOLECULES[0] : RealMoleculeShape.TAB_2_MOLECULES[0];
        RealMolecule realMolecule = new RealMolecule(realMoleculeShape);
        this.setMolecule(realMolecule);
        this.realMolecule.set(realMoleculeShape);
    }

    public void initialize() {
        super.initialize();
        this.initializeResources();
        this.moleculeNode = new MoleculeModelNode(this.getMolecule(), this.readoutLayer, this);
        this.sceneLayer.addChild(this.moleculeNode);
        this.showRealView.addObserver(new SimpleObserver(){

            public void update() {
                RealMoleculesTab.this.rebuildMolecule(false);
            }
        }, false);
        Property<Vector2D> property = new Property<Vector2D>(new Vector2D());
        Function0<Double> function0 = new Function0<Double>(){

            @Override
            public Double apply() {
                return ((Vector2D)((RealMoleculesTab)RealMoleculesTab.this).controlPanel.position.get()).getX();
            }
        };
        RealMoleculesControlPanel realMoleculesControlPanel = new RealMoleculesControlPanel(this, function0, this.isBasicsVersion);
        this.controlPanel = new OrthoPiccoloNode(realMoleculesControlPanel, this, this.canvasTransform, property, this.mouseEventNotifier){
            {
                this.updateOnEvent(RealMoleculesTab.this.beforeFrameRender);
            }
        };
        this.guiLayer.addChild(this.controlPanel);
        this.guiNodes.add(this.controlPanel);
        this.controlPanel.onResize.addUpdateListener(new UpdateListener(){

            public void update() {
                if (RealMoleculesTab.this.controlPanel != null) {
                    ((RealMoleculesTab)RealMoleculesTab.this).controlPanel.position.set(new Vector2D((float)(RealMoleculesTab.this.getStageSize().width - RealMoleculesTab.this.controlPanel.getComponentWidth()) - 10.0f, 10.0));
                }
                RealMoleculesTab.this.resizeDirty = true;
            }
        }, true);
        if (!this.isBasicsVersion) {
            PNode pNode = new PNode(){
                {
                    this.addChild(new PNode(){
                        {
                            this.scale(1.5);
                            final PropertyRadioButtonNode<Boolean> propertyRadioButtonNode = new PropertyRadioButtonNode<Boolean>(MoleculeShapesSimSharing.UserComponents.realViewCheckBox, MoleculeShapesResources.Strings.CONTROL__REAL_VIEW, RealMoleculesTab.this.showRealView, true);
                            MoleculeShapesApplication.showRealMoleculeRadioButtons.addObserver(new SimpleObserver(){

                                public void update() {
                                    if (MoleculeShapesApplication.showRealMoleculeRadioButtons.get().booleanValue()) {
                                        this.addChild(propertyRadioButtonNode);
                                    } else {
                                        this.removeChild(propertyRadioButtonNode);
                                    }
                                }
                            });
                            final PropertyRadioButtonNode<Boolean> propertyRadioButtonNode2 = new PropertyRadioButtonNode<Boolean>(MoleculeShapesSimSharing.UserComponents.modelViewCheckBox, MoleculeShapesResources.Strings.CONTROL__MODEL_VIEW, RealMoleculesTab.this.showRealView, false);
                            MoleculeShapesApplication.showRealMoleculeRadioButtons.addObserver(new SimpleObserver(){

                                public void update() {
                                    if (MoleculeShapesApplication.showRealMoleculeRadioButtons.get().booleanValue()) {
                                        this.addChild(propertyRadioButtonNode2);
                                    } else {
                                        this.removeChild(propertyRadioButtonNode2);
                                    }
                                }
                            });
                            propertyRadioButtonNode2.setOffset(propertyRadioButtonNode.getFullBounds().getMaxX() + 10.0, 0.0);
                        }
                    });
                }
            };
            OrthoPiccoloNode orthoPiccoloNode = new OrthoPiccoloNode(pNode, this, this.canvasTransform, new Property<Vector2D>(new Vector2D((int)((double)this.getStageSize().width - pNode.getFullBounds().getWidth() - realMoleculesControlPanel.getFullBounds().getWidth()) / 2, 10.0)), this.mouseEventNotifier){
                {
                    this.updateOnEvent(RealMoleculesTab.this.beforeFrameRender);
                }
            };
            this.guiLayer.addChild(orthoPiccoloNode);
            this.guiNodes.add(orthoPiccoloNode);
        }
        this.namePanel = new OrthoPiccoloNode(new MoleculeShapesPanelNode((PNode)new GeometryNameNode(this.getMoleculeProperty(), !this.isBasicsVersion), MoleculeShapesResources.Strings.CONTROL__GEOMETRY_NAME){}, this, this.canvasTransform, new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                this.onResize.addUpdateListener(new UpdateListener(){

                    public void update() {
                        position.set(new Vector2D(10.0, (int)(RealMoleculesTab.this.getStageSize().getHeight() - (double)this.getComponentHeight() - 10.0)));
                    }
                }, true);
                this.updateOnEvent(RealMoleculesTab.this.beforeFrameRender);
            }
        };
        this.guiLayer.addChild(this.namePanel);
        this.guiNodes.add(this.namePanel);
    }

    public void switchToMolecule(RealMoleculeShape realMoleculeShape) {
        this.realMolecule.set(realMoleculeShape);
        this.rebuildMolecule(true);
    }

    private void rebuildMolecule(final boolean bl) {
        this.moleculeNode.detachReadouts();
        this.sceneLayer.removeChild(this.moleculeNode);
        Molecule molecule = this.getMolecule();
        final int n = this.realMolecule.get().getCentralAtomCount();
        final int n2 = this.realMolecule.get().getCentralLonePairCount();
        VseprConfiguration vseprConfiguration = new VseprConfiguration(n, n2);
        final Molecule molecule2 = bl ? new RealMolecule(this.realMolecule.get()) : molecule;
        if (this.showRealView.get().booleanValue()) {
            this.setMolecule(new RealMolecule(this.realMolecule.get()){
                {
                    super(realMoleculeShape);
                    if (!bl) {
                        List<PairGroup> list = new RealMolecule(RealMoleculesTab.this.realMolecule.get()).getRadialGroups();
                        AttractorModel.ResultMapping resultMapping = AttractorModel.findClosestMatchingConfiguration(AttractorModel.getOrientationsFromOrigin(molecule2.getRadialGroups()), FunctionalUtils.map(LocalShape.sortedLonePairsFirst(list), new Function1<PairGroup, Vector3D>(){

                            @Override
                            public Vector3D apply(PairGroup pairGroup) {
                                return pairGroup.position.get().normalized();
                            }
                        }), LocalShape.vseprPermutations(molecule2.getRadialGroups()));
                        for (PairGroup pairGroup : this.getGroups()) {
                            if (pairGroup == this.getCentralAtom()) continue;
                            pairGroup.position.set(resultMapping.rotateVector(pairGroup.position.get()));
                        }
                    }
                }
            });
        } else {
            final AttractorModel.ResultMapping resultMapping = vseprConfiguration.getIdealGroupRotationToPositions(LocalShape.sortedLonePairsFirst(molecule2.getRadialGroups()));
            final Permutation permutation = resultMapping.permutation.inverted();
            final List<Vector3D> list = vseprConfiguration.getAllUnitVectors();
            this.setMolecule(new VSEPRMolecule(){
                {
                    PairGroup pairGroup = new PairGroup(new Vector3D(), false, false);
                    this.addCentralAtom(pairGroup);
                    for (int i = 0; i < n + n2; ++i) {
                        Vector3D vector3D = resultMapping.rotateVector((Vector3D)list.get(i));
                        if (i < n2) {
                            this.addGroup(new PairGroup(vector3D.times(7.0), true, false), pairGroup, 0);
                            continue;
                        }
                        PairGroup pairGroup2 = molecule2.getRadialAtoms().get(permutation.apply(i) - n2);
                        Bond<PairGroup> bond = molecule2.getParentBond(pairGroup2);
                        PairGroup pairGroup3 = new PairGroup(vector3D.times(bond.length * 5.5), false, false);
                        this.addGroup(pairGroup3, pairGroup, bond.order, bond.length);
                        this.addTerminalLonePairs(pairGroup3, FunctionalUtils.count(molecule2.getNeighbors(pairGroup2), new Function1<PairGroup, Boolean>(){

                            @Override
                            public Boolean apply(PairGroup pairGroup) {
                                return pairGroup.isLonePair;
                            }
                        }));
                    }
                }
            });
        }
        this.moleculeNode = new MoleculeModelNode(this.getMolecule(), this.readoutLayer, this);
        this.sceneLayer.addChild(this.moleculeNode);
    }

    public void updateState(float f) {
        this.moleculeNode.transform.set(Matrix4F.translation(new Vector3F(-4.5f, 1.5f, 0.0f)).times(((QuaternionF)this.rotation.get()).toRotationMatrix().toMatrix4f()));
        this.getMolecule().update(f);
        this.moleculeNode.updateView();
        if (this.resizeDirty && this.controlPanel != null) {
            this.resizeDirty = false;
        }
    }

    public boolean shouldUseKit() {
        return this.useKit;
    }

    public boolean allowTogglingLonePairs() {
        return !this.isBasicsVersion;
    }

    public boolean allowTogglingAllLonePairs() {
        return false;
    }

    public boolean allowMiddleMouseClickModifications() {
        return false;
    }

    public boolean isRealTab() {
        return true;
    }

    private void initializeResources() {
        LonePairNode.getGeometry();
    }

    public IUserComponent getUserComponent() {
        return this.useKit ? MoleculeShapesSimSharing.UserComponents.realMoleculesTabWithKit : MoleculeShapesSimSharing.UserComponents.realMoleculesTabWithComboBox;
    }
}

