/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.view;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.MoleculeShapesProperties;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.model.RealPairGroup;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomNode
extends GLNode {
    public final PairGroup pair;
    public final Property<Vector3D> position;
    private final Property<Color> color;
    private final float radius;

    public AtomNode(Option<PairGroup> option) {
        Property<Color> property;
        Property<Vector3D> property2;
        if (option.isSome()) {
            property2 = option.get().position;
        } else {
            Property<Vector3D> property3;
            property2 = property3;
            super(new Vector3D());
        }
        if (option.isSome()) {
            if (option.get() instanceof RealPairGroup) {
                Property<Color> property4;
                property = property4;
                super(((RealPairGroup)option.get()).getElement().getColor());
            } else {
                property = MoleculeShapesColor.ATOM.getProperty();
            }
        } else {
            property = MoleculeShapesColor.ATOM_CENTER.getProperty();
        }
        this(property2, option, property, 2.0f);
    }

    public AtomNode(final Property<Vector3D> property, Option<PairGroup> option, Property<Color> property2, float f) {
        this.color = property2;
        this.radius = f;
        this.pair = option.isSome() ? option.get() : null;
        this.position = property;
        property.addObserver(new SimpleObserver(){

            public void update() {
                AtomNode.this.transform.set(Matrix4F.translation((float)((Vector3D)property.get()).getX(), (float)((Vector3D)property.get()).getY(), (float)((Vector3D)property.get()).getZ()));
            }
        });
        this.requireEnabled(2903);
        this.requireEnabled(2884);
        this.requireEnabled(2896);
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        GL11.glColorMaterial(1028, 4609);
        LWJGLUtils.color4f(this.color.get());
        new Sphere().draw(this.radius, MoleculeShapesProperties.sphereSamples.get(), MoleculeShapesProperties.sphereSamples.get());
    }

    public float getRadius() {
        return this.radius;
    }
}

