/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.materials.GLMaterial;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.shapes.PointArc;
import edu.colorado.phet.lwjglphet.shapes.Sector;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.tabs.MoleculeViewTab;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class BondAngleNode
extends GLNode {
    private PointArc arc;
    private boolean initialized = false;
    private final MoleculeViewTab module;
    private final Molecule molecule;
    private final PairGroup aGroup;
    private final PairGroup bGroup;
    private Sector sector;
    private Property<Float> alpha = new Property<Float>(Float.valueOf(0.0f));
    private static final float[] lowThresholds = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.35f, 0.45f, 0.5f};
    private static final float[] highThresholds = new float[]{0.0f, 0.0f, 0.0f, 0.5f, 0.55f, 0.65f, 0.75f};

    public BondAngleNode(final MoleculeViewTab moleculeViewTab, Molecule molecule, PairGroup pairGroup, PairGroup pairGroup2) {
        this.module = moleculeViewTab;
        this.molecule = molecule;
        this.aGroup = pairGroup;
        this.bGroup = pairGroup2;
        this.requireEnabled(3042);
        this.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
        moleculeViewTab.showBondAngles.addObserver(new SimpleObserver(){

            public void update() {
                BondAngleNode.this.setVisible(moleculeViewTab.showBondAngles.get());
            }
        });
    }

    protected void preRender(GLOptions gLOptions) {
        super.preRender(gLOptions);
        GL11.glPushAttrib(2930);
        GL11.glDepthMask(false);
    }

    protected void postRender(GLOptions gLOptions) {
        GL11.glPopAttrib();
        super.postRender(gLOptions);
    }

    public void initialize(Vector3F vector3F, Vector3F vector3F2, Vector3F vector3F3) {
        this.arc = new PointArc(vector3F, vector3F2, 5.0f, 25, vector3F3){

            protected void preRender(GLOptions gLOptions) {
                super.preRender(gLOptions);
                GL11.glPushAttrib(2849);
                GL11.glLineWidth(2.0f);
                Color color = MoleculeShapesColor.BOND_ANGLE_ARC.get();
                LWJGLUtils.color4f(new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, ((Float)BondAngleNode.this.alpha.get()).floatValue() / 2.0f));
            }

            protected void postRender(GLOptions gLOptions) {
                GL11.glPopAttrib();
                super.postRender(gLOptions);
            }
        };
        this.addChild(this.arc);
        GLMaterial gLMaterial = new GLMaterial(){

            public void before(GLOptions gLOptions) {
                super.before(gLOptions);
                Color color = MoleculeShapesColor.BOND_ANGLE_SWEEP.get();
                LWJGLUtils.color4f(new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, ((Float)BondAngleNode.this.alpha.get()).floatValue() / 2.0f));
            }

            public void after(GLOptions gLOptions) {
                super.after(gLOptions);
            }
        };
        this.sector = new Sector(this.arc);
        this.sector.setMaterial(gLMaterial);
        this.addChild(this.sector);
    }

    public PairGroup getA() {
        return this.aGroup;
    }

    public PairGroup getB() {
        return this.bGroup;
    }

    public void updateView(Vector3F vector3F, Vector3F vector3F2) {
        Vector3D vector3D = this.aGroup.position.get().normalized();
        Vector3D vector3D2 = this.bGroup.position.get().normalized();
        this.alpha.set(Float.valueOf(BondAngleNode.calculateBrightness(vector3D, vector3D2, vector3F, this.molecule.getRadialAtoms().size())));
        Vector3F vector3F3 = vector3D.to3F();
        Vector3F vector3F4 = vector3D2.to3F();
        if (!this.initialized) {
            this.initialized = true;
            this.initialize(vector3F3, vector3F4, vector3F2);
        } else {
            this.arc.updateView(vector3F3, vector3F4, vector3F2);
            this.sector.updateView();
        }
    }

    public static float calculateBrightness(Vector3D vector3D, Vector3D vector3D2, Vector3F vector3F, int n) {
        if (n <= 2) {
            return 1.0f;
        }
        float f = (float)Math.abs(vector3D.cross(vector3D2).dot(vector3F.to3D()));
        float f2 = lowThresholds[n];
        float f3 = highThresholds[n];
        float f4 = f / (f3 - f2) - f2 / (f3 - f2);
        return (float)MathUtil.clamp(0.0, f4, 1.0);
    }

    public Vector3F getCenter() {
        return Vector3F.ZERO;
    }

    public Vector3F getMidpoint() {
        return this.arc.getMidpoint();
    }
}

