/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.view;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.QuaternionF;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesProperties;
import edu.colorado.phet.moleculeshapes.tabs.MoleculeViewTab;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Cylinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BondNode
extends GLNode {
    private final Property<Vector3D> a;
    private final Property<Vector3D> b;
    private final int bondOrder;
    private final float bondRadius;
    private final Option<Float> maxLength;
    private final MoleculeViewTab tab;
    private final SingleBondNode[] aBonds;
    private final SingleBondNode[] bBonds;
    private boolean fixedCamera = false;

    public BondNode(Property<Vector3D> property, Property<Vector3D> property2, int n, float f, Option<Float> option, MoleculeViewTab moleculeViewTab) {
        this(property, property2, n, f, option, moleculeViewTab, Color.WHITE, Color.WHITE);
    }

    private BondNode(Property<Vector3D> property, Property<Vector3D> property2, int n, float f, Option<Float> option, MoleculeViewTab moleculeViewTab, Color color, Color color2) {
        this.a = property;
        this.b = property2;
        this.bondOrder = n;
        this.bondRadius = f;
        this.maxLength = option;
        this.tab = moleculeViewTab;
        this.aBonds = new SingleBondNode[n];
        this.bBonds = new SingleBondNode[n];
        for (int i = 0; i < n; ++i) {
            this.aBonds[i] = new SingleBondNode(1.0f, 1.0f, color);
            this.bBonds[i] = new SingleBondNode(1.0f, 1.0f, color2);
            this.addChild(this.aBonds[i]);
            this.addChild(this.bBonds[i]);
        }
        this.updateView();
    }

    public void setFixedCamera(boolean bl) {
        this.fixedCamera = bl;
        this.updateView();
    }

    public void updateView() {
        Vector3F[] vector3FArray;
        float f;
        Vector3F vector3F = this.transform.inversePosition(Vector3F.ZERO);
        Vector3F vector3F2 = this.getGlobalTransform().inversePosition(this.tab.getCameraRay((int)0, (int)0).pos);
        if (this.fixedCamera) {
            vector3F2 = new Vector3F(0.0f, 0.0f, 45.0f);
        }
        Vector3F vector3F3 = this.a.get().to3F();
        Vector3F vector3F4 = this.b.get().to3F();
        Vector3F vector3F5 = vector3F4.minus(vector3F3).normalized();
        float f2 = vector3F3.distance(vector3F4);
        float f3 = 0.0f;
        if (this.maxLength.isSome() && f2 > this.maxLength.get().floatValue()) {
            f = this.maxLength.get().floatValue();
            f3 = f2 - this.maxLength.get().floatValue();
        } else {
            f = f2;
        }
        Vector3F vector3F6 = vector3F3.times(0.5f).plus(vector3F4.times(0.5f)).plus(vector3F5.times(f3 / 2.0f));
        Vector3F vector3F7 = vector3F6.minus(vector3F4).normalized().cross(vector3F6.minus(vector3F2).normalized()).normalized();
        float f4 = this.bondRadius * 2.4f;
        switch (this.bondOrder) {
            case 1: {
                vector3FArray = new Vector3F[]{new Vector3F()};
                break;
            }
            case 2: {
                vector3FArray = new Vector3F[]{vector3F7.times(f4 / 2.0f), vector3F7.times(-f4 / 2.0f)};
                break;
            }
            case 3: {
                vector3FArray = new Vector3F[]{Vector3F.ZERO, vector3F7.times(f4), vector3F7.times(-f4)};
                break;
            }
            default: {
                throw new RuntimeException("bad bond order: " + this.bondOrder);
            }
        }
        Vector3F vector3F8 = vector3F5.times(f / 4.0f);
        for (int i = 0; i < this.bondOrder; ++i) {
            this.aBonds[i].transform.set(Matrix4F.translation(vector3F6.plus(vector3FArray[i]).minus(vector3F8)).times(Matrix4F.fromMatrix3f(QuaternionF.getRotationQuaternion(Vector3F.Z_UNIT, vector3F5).toRotationMatrix())).times(Matrix4F.scaling(this.bondRadius, this.bondRadius, f / 2.0f)));
            this.bBonds[i].transform.set(Matrix4F.translation(vector3F6.plus(vector3FArray[i]).plus(vector3F8)).times(Matrix4F.fromMatrix3f(QuaternionF.getRotationQuaternion(Vector3F.Z_UNIT, vector3F5).toRotationMatrix())).times(Matrix4F.scaling(this.bondRadius, this.bondRadius, f / 2.0f)));
        }
    }

    public static class SingleBondNode
    extends GLNode {
        private final float length;
        private final float bondRadius;
        private final Color color;

        public SingleBondNode(float f, float f2, Color color) {
            this.length = f;
            this.bondRadius = f2;
            this.color = color;
            this.requireEnabled(2903);
            this.requireEnabled(2884);
            this.requireEnabled(2896);
            this.requireEnabled(2977);
        }

        public void renderSelf(GLOptions gLOptions) {
            super.renderSelf(gLOptions);
            GL11.glColorMaterial(1028, 4609);
            LWJGLUtils.color4f(this.color);
            GL11.glTranslatef(0.0f, 0.0f, -this.length / 2.0f);
            new Cylinder().draw(this.bondRadius, this.bondRadius, this.length, MoleculeShapesProperties.cylinderSamples.get(), 1);
            GL11.glTranslatef(0.0f, 0.0f, this.length / 2.0f);
        }
    }
}

