/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.view;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.SphereF;
import edu.colorado.phet.common.phetcommon.math.Triangle3F;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.nodes.ThreadedPlanarPiccoloNode;
import edu.colorado.phet.lwjglphet.shapes.ObjMesh;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.MoleculeShapesConstants;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.control.BondTypeOverlayNode;
import edu.colorado.phet.moleculeshapes.model.Bond;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.tabs.MoleculeViewTab;
import edu.colorado.phet.moleculeshapes.tabs.moleculeshapes.MoleculeShapesTab;
import edu.colorado.phet.moleculeshapes.tabs.realmolecules.RealMoleculesTab;
import edu.colorado.phet.moleculeshapes.view.AtomNode;
import edu.colorado.phet.moleculeshapes.view.BondAngleNode;
import edu.colorado.phet.moleculeshapes.view.BondNode;
import edu.colorado.phet.moleculeshapes.view.LonePairNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculeModelNode
extends GLNode {
    private Molecule molecule;
    private final GLNode readoutLayer;
    private final MoleculeViewTab tab;
    private List<AtomNode> atomNodes = new ArrayList<AtomNode>();
    private List<LonePairNode> lonePairNodes = new ArrayList<LonePairNode>();
    private List<BondNode> bondNodes = new ArrayList<BondNode>();
    private List<BondAngleNode> angleNodes = new ArrayList<BondAngleNode>();
    private int angleIndex = 0;
    private List<ReadoutNode> angleReadouts = new ArrayList<ReadoutNode>();
    private AtomNode centerAtomNode;
    private float scaleOverride = 0.0f;
    private DecimalFormat angleFormat = new DecimalFormat("##0.0");
    private Vector3F lastMidpoint = null;

    public MoleculeModelNode(Molecule molecule, GLNode gLNode, MoleculeViewTab moleculeViewTab) {
        this.molecule = molecule;
        this.readoutLayer = gLNode;
        this.tab = moleculeViewTab;
        molecule.onGroupAdded.addListener(new VoidFunction1<PairGroup>(){

            @Override
            public void apply(PairGroup pairGroup) {
                MoleculeModelNode.this.addGroup(pairGroup);
            }
        });
        molecule.onGroupRemoved.addListener(new VoidFunction1<PairGroup>(){

            @Override
            public void apply(PairGroup pairGroup) {
                MoleculeModelNode.this.removeGroup(pairGroup);
            }
        });
        molecule.onBondAdded.addListener(new VoidFunction1<Bond<PairGroup>>(){

            @Override
            public void apply(Bond<PairGroup> bond) {
                MoleculeModelNode.this.addBond(bond);
            }
        });
        molecule.onBondRemoved.addListener(new VoidFunction1<Bond<PairGroup>>(){

            @Override
            public void apply(Bond<PairGroup> bond) {
                MoleculeModelNode.this.removeBond(bond);
            }
        });
        for (PairGroup pairGroup : molecule.getRadialGroups()) {
            this.addGroup(pairGroup);
        }
        for (PairGroup pairGroup : molecule.getDistantLonePairs()) {
            this.addGroup(pairGroup);
        }
        this.centerAtomNode = !molecule.isReal() ? new AtomNode(new Option.None<PairGroup>()) : new AtomNode(new Option.Some<PairGroup>(molecule.getCentralAtom()));
        this.addChild(this.centerAtomNode);
    }

    public GLNode intersect(Ray3F ray3F) {
        Object object;
        GLNode object2 = null;
        float f = Float.POSITIVE_INFINITY;
        for (AtomNode object3 : this.atomNodes) {
            Ray3F ray3F2 = object3.getGlobalTransform().inverseRay(ray3F);
            object = new SphereF(Vector3F.ZERO, object3.getRadius()).intersect(ray3F2, 1.0E-5f);
            if (object == null || !(((SphereF.SphereIntersectionResult)object).distance < f)) continue;
            f = ((SphereF.SphereIntersectionResult)object).distance;
            object2 = object3;
        }
        ObjMesh objMesh = LonePairNode.getMesh();
        block1: for (LonePairNode lonePairNode : this.lonePairNodes) {
            object = lonePairNode.getGlobalTransform().inverseRay(ray3F);
            if (!objMesh.getBoundingBox().intersectedBy((Ray3F)object)) continue;
            for (Triangle3F triangle3F : objMesh.getTriangles()) {
                Option<Triangle3F.TriangleIntersectionResult> option = triangle3F.intersectWith((Ray3F)object);
                if (!option.isSome()) continue;
                float f2 = option.get().point.distance(((Ray3F)object).pos);
                if (!(f2 < f)) continue block1;
                f = f2;
                object2 = lonePairNode;
                continue block1;
            }
        }
        return object2;
    }

    protected void setScaleOverride(float f) {
        this.scaleOverride = f;
    }

    private void addBond(Bond<PairGroup> bond) {
        this.rebuildBonds();
        this.updateAngles();
    }

    private void removeBond(Bond<PairGroup> bond) {
        this.rebuildBonds();
        this.updateAngles();
    }

    private void addGroup(PairGroup pairGroup) {
        if (pairGroup == this.molecule.getCentralAtom()) {
            return;
        }
        if (pairGroup.isLonePair) {
            PairGroup pairGroup2 = this.molecule.getParent(pairGroup);
            Property<Boolean> property = pairGroup2 == this.molecule.getCentralAtom() ? this.tab.showLonePairs : this.tab.showAllLonePairs;
            LonePairNode lonePairNode = new LonePairNode(pairGroup, pairGroup2, property);
            this.lonePairNodes.add(lonePairNode);
            this.addChild(lonePairNode);
        } else {
            AtomNode atomNode = new AtomNode(new Option.Some<PairGroup>(pairGroup));
            this.atomNodes.add(atomNode);
            this.addChild(atomNode);
            this.rebuildBonds();
            this.updateAngles();
            for (PairGroup pairGroup3 : this.molecule.getRadialAtoms()) {
                if (pairGroup3 == pairGroup) continue;
                BondAngleNode bondAngleNode = new BondAngleNode(this.tab, this.molecule, pairGroup, pairGroup3);
                this.addChild(bondAngleNode);
                this.angleNodes.add(bondAngleNode);
            }
        }
    }

    private void removeGroup(PairGroup pairGroup) {
        if (pairGroup.isLonePair) {
            for (LonePairNode lonePairNode : new ArrayList<LonePairNode>(this.lonePairNodes)) {
                if (lonePairNode.position != pairGroup.position) continue;
                this.lonePairNodes.remove(lonePairNode);
                this.removeChild(lonePairNode);
            }
        } else {
            for (AtomNode gLNode : new ArrayList<AtomNode>(this.atomNodes)) {
                if (gLNode.position != pairGroup.position) continue;
                this.atomNodes.remove(gLNode);
                this.removeChild(gLNode);
            }
            for (BondAngleNode bondAngleNode : new ArrayList<BondAngleNode>(this.angleNodes)) {
                if (bondAngleNode.getA() != pairGroup && bondAngleNode.getB() != pairGroup) continue;
                LWJGLUtils.discardTree(bondAngleNode);
                this.angleNodes.remove(bondAngleNode);
            }
        }
    }

    public void updateView() {
        for (BondNode bondNode : this.bondNodes) {
            bondNode.updateView();
        }
        this.updateAngles();
    }

    private void rebuildBonds() {
        for (BondNode object : this.bondNodes) {
            LWJGLUtils.discardTree(object);
        }
        this.bondNodes.clear();
        for (final PairGroup pairGroup : this.molecule.getRadialAtoms()) {
            BondNode bondNode = new BondNode(new Property<Vector3D>(new Vector3D()), pairGroup.position, FunctionalUtils.first(this.molecule.getBonds((PairGroup)pairGroup), new Function1<Bond<PairGroup>, Boolean>(){

                @Override
                public Boolean apply(Bond<PairGroup> bond) {
                    return bond.getOtherAtom(pairGroup) == MoleculeModelNode.this.molecule.getCentralAtom();
                }
            }).get().order, 0.5f, this.molecule.getMaximumBondLength(), this.tab);
            if (this instanceof BondTypeOverlayNode) {
                bondNode.setFixedCamera(true);
            }
            this.addChild(bondNode);
            this.bondNodes.add(bondNode);
        }
    }

    private void updateAngles() {
        Object object;
        boolean bl;
        Vector3F vector3F = this.tab.getCameraRay((int)0, (int)0).pos;
        Vector3F vector3F2 = this.transform.inverseNormal(vector3F).normalized();
        boolean bl2 = bl = this.molecule.getRadialAtoms().size() == 2;
        if (!bl) {
            this.lastMidpoint = null;
        }
        for (BondAngleNode bondAngleNode : this.angleNodes) {
            bondAngleNode.updateView(vector3F2, this.lastMidpoint);
            if (!bl) continue;
            this.lastMidpoint = bondAngleNode.getMidpoint().normalized();
        }
        this.angleIndex = 0;
        boolean bl3 = !this.molecule.getRadialLonePairs().isEmpty();
        HashMap<PairGroup, Vector3D> hashMap = new HashMap<PairGroup, Vector3D>();
        if (bl3) {
            for (PairGroup object2 : this.molecule.getRadialAtoms()) {
                object = object2.position.get();
                for (PairGroup pairGroup : this.molecule.getGroups()) {
                    if (pairGroup == object2) continue;
                    double d = pairGroup.isLonePair ? 1.2 : 1.0;
                    object = ((AbstractVector3D)object).plus(object2.getRepulsionImpulse(pairGroup, 0.1, 1.0)).times(d);
                }
                hashMap.put(object2, ((AbstractVector3D)object).normalized());
            }
        }
        if (this.tab.showBondAngles.get().booleanValue()) {
            for (BondAngleNode bondAngleNode : this.angleNodes) {
                String string;
                Vector3D vector3D;
                object = bondAngleNode.getA();
                PairGroup pairGroup = bondAngleNode.getB();
                Vector3D vector3D2 = ((PairGroup)object).position.get().normalized();
                float f = BondAngleNode.calculateBrightness(vector3D2, vector3D = pairGroup.position.get().normalized(), vector3F2, this.molecule.getRadialAtoms().size());
                if (f == 0.0f) continue;
                LWJGLTransform lWJGLTransform = bondAngleNode.getGlobalTransform();
                Vector3F vector3F3 = lWJGLTransform.transformPosition(bondAngleNode.getCenter());
                Vector3F vector3F4 = lWJGLTransform.transformPosition(bondAngleNode.getMidpoint());
                Vector3F vector3F5 = new Vector3F(this.tab.getScreenCoordinatesFromViewPoint(vector3F3));
                Vector3F vector3F6 = new Vector3F(this.tab.getScreenCoordinatesFromViewPoint(vector3F4));
                float f2 = 1.3f * (this.tab instanceof RealMoleculesTab ? 1.1f : 1.05f);
                Vector3F vector3F7 = vector3F6.minus(vector3F5).times(f2).plus(vector3F5);
                double d = vector3D2.angleBetweenInDegrees(vector3D);
                if (bl3) {
                    double d2 = ((Vector3D)hashMap.get(object)).angleBetweenInDegrees((AbstractVector3D)hashMap.get(pairGroup));
                    String string2 = MoleculeShapesResources.Strings.ANGLE__DEGREES;
                    if (SimSharingManager.getInstance().isEnabled() && (SimSharingManager.getInstance().getStudyName().equals("colorado") || SimSharingManager.getInstance().getStudyName().equals("utah"))) {
                        string2 = d2 - d > 0.05 ? MoleculeShapesResources.Strings.ANGLE__GREATER_THAN_DEGREES : (d2 - d < -0.05 ? MoleculeShapesResources.Strings.ANGLE__LESS_THAN_DEGREES : MoleculeShapesResources.Strings.ANGLE__DEGREES);
                    }
                    string = MessageFormat.format(string2, this.angleFormat.format(d));
                } else {
                    string = MessageFormat.format(MoleculeShapesResources.Strings.ANGLE__DEGREES, this.angleFormat.format(d));
                }
                this.showAngleLabel(string, f, vector3F7);
            }
        }
        this.removeRemainingLabels();
    }

    public void detachReadouts() {
        for (ReadoutNode readoutNode : this.angleReadouts) {
            readoutNode.detach();
        }
    }

    private void showAngleLabel(String string, float f, Vector3F vector3F) {
        if (this.angleIndex >= this.angleReadouts.size()) {
            this.angleReadouts.add(new ReadoutNode(new PText("...")));
        }
        this.angleReadouts.get(this.angleIndex).attach(string, f, vector3F);
        ++this.angleIndex;
    }

    private void removeRemainingLabels() {
        for (int i = this.angleIndex; i < this.angleReadouts.size(); ++i) {
            this.angleReadouts.get(i).detach();
        }
    }

    public AtomNode getCenterAtomNode() {
        return this.centerAtomNode;
    }

    private class ReadoutNode
    extends ThreadedPlanarPiccoloNode {
        private final PText text;
        private volatile boolean attached;

        private ReadoutNode(PText pText) {
            super(pText);
            this.attached = false;
            this.text = pText;
            pText.setFont(MoleculeShapesConstants.BOND_ANGLE_READOUT_FONT);
        }

        public void attach(String string, float f, Vector3F vector3F) {
            float f2;
            float f3 = MoleculeModelNode.this.tab instanceof MoleculeShapesTab ? (((MoleculeShapesTab)MoleculeModelNode.this.tab).isBasicsVersion() ? 1.2f : 1.0f) : (f2 = 1.5f);
            if (!this.text.getText().equals(string)) {
                this.text.setText(string);
            }
            float f4 = (MoleculeModelNode.this.scaleOverride == 0.0f ? MoleculeModelNode.this.tab.getApproximateScale() : MoleculeModelNode.this.scaleOverride) * f2;
            this.text.setScale(f4);
            float[] fArray = MoleculeShapesColor.BOND_ANGLE_READOUT.get().getRGBColorComponents(null);
            this.text.setTextPaint(new Color(fArray[0], fArray[1], fArray[2], f));
            this.text.repaint();
            this.repaint();
            this.transform.set(Matrix4F.translation(vector3F.minus(this.getWidth() / 2, this.getHeight() / 2, 0.0f)));
            if (!this.attached) {
                this.attached = true;
                MoleculeModelNode.this.readoutLayer.addChild(this);
            }
        }

        public void detach() {
            if (this.attached) {
                this.attached = false;
                MoleculeModelNode.this.readoutLayer.removeChild(this);
            }
        }
    }
}

