/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerWrapper;

public class PointerBuffer
implements Comparable {
    private static final boolean is64Bit;
    protected final ByteBuffer pointers;
    protected final Buffer view;
    protected final IntBuffer view32;
    protected final LongBuffer view64;

    public PointerBuffer(int capacity) {
        this(BufferUtils.createByteBuffer(capacity * PointerBuffer.getPointerSize()));
    }

    public PointerBuffer(ByteBuffer source) {
        if (!source.isDirect()) {
            throw new IllegalArgumentException("ByteBuffer is not direct");
        }
        this.pointers = source.slice().order(source.order());
        if (is64Bit) {
            this.view32 = null;
            this.view64 = this.pointers.asLongBuffer();
            this.view = this.view64;
        } else {
            this.view32 = this.pointers.asIntBuffer();
            this.view = this.view32;
            this.view64 = null;
        }
    }

    public ByteBuffer getBuffer() {
        return this.pointers;
    }

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static int getPointerSize() {
        return is64Bit ? 8 : 4;
    }

    public final int capacity() {
        return this.view.capacity();
    }

    public final int position() {
        return this.view.position();
    }

    public final int positionByte() {
        return this.position() * PointerBuffer.getPointerSize();
    }

    public final PointerBuffer position(int newPosition) {
        this.view.position(newPosition);
        return this;
    }

    public final int limit() {
        return this.view.limit();
    }

    public final PointerBuffer limit(int newLimit) {
        this.view.limit(newLimit);
        return this;
    }

    public final PointerBuffer clear() {
        this.view.clear();
        return this;
    }

    public final PointerBuffer flip() {
        this.view.flip();
        return this;
    }

    public final int remaining() {
        return this.view.remaining();
    }

    public final int remainingByte() {
        return this.remaining() * PointerBuffer.getPointerSize();
    }

    public static PointerBuffer allocateDirect(int capacity) {
        return new PointerBuffer(capacity);
    }

    public PointerBuffer put(long l) {
        if (is64Bit) {
            this.view64.put(l);
        } else {
            this.view32.put((int)l);
        }
        return this;
    }

    public PointerBuffer put(PointerWrapper pointer) {
        return this.put(pointer.getPointer());
    }

    public long get(int index) {
        if (is64Bit) {
            return this.view64.get(index);
        }
        return (long)this.view32.get(index) & 0xFFFFFFFFL;
    }

    public PointerBuffer put(int index, long l) {
        if (is64Bit) {
            this.view64.put(index, l);
        } else {
            this.view32.put(index, (int)l);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(48);
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.position());
        sb.append(" lim=");
        sb.append(this.limit());
        sb.append(" cap=");
        sb.append(this.capacity());
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + (int)this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof PointerBuffer)) {
            return false;
        }
        PointerBuffer that = (PointerBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public int compareTo(Object o) {
        PointerBuffer that = (PointerBuffer)o;
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean is64 = false;
        try {
            Method m = Class.forName("org.lwjgl.Sys").getDeclaredMethod("is64Bit", null);
            is64 = (Boolean)m.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
        }
        finally {
            is64Bit = is64;
        }
    }
}

