/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.LinuxSysImplementation;
import org.lwjgl.MacOSXSysImplementation;
import org.lwjgl.SysImplementation;
import org.lwjgl.WindowsSysImplementation;

public final class Sys {
    private static final SysImplementation implementation = Sys.createImplementation();
    private static final boolean is64Bit;

    private static void doLoadLibrary(final String lib_name) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String library_path = System.getProperty("org.lwjgl.librarypath");
                if (library_path != null) {
                    System.load(library_path + File.separator + System.mapLibraryName(lib_name));
                } else {
                    System.loadLibrary(lib_name);
                }
                return null;
            }
        });
    }

    private static void loadLibrary(String lib_name) {
        try {
            Sys.doLoadLibrary(lib_name);
        }
        catch (UnsatisfiedLinkError e) {
            if (implementation.has64Bit()) {
                try {
                    Sys.doLoadLibrary(lib_name + "64");
                    return;
                }
                catch (UnsatisfiedLinkError e2) {
                    LWJGLUtil.log("Failed to load 64 bit library: " + e2.getMessage());
                }
            }
            throw e;
        }
    }

    private static SysImplementation createImplementation() {
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                return new LinuxSysImplementation();
            }
            case 3: {
                return new WindowsSysImplementation();
            }
            case 2: {
                return new MacOSXSysImplementation();
            }
        }
        throw new IllegalStateException("Unsupported platform");
    }

    private Sys() {
    }

    public static void initialize() {
    }

    public static long getTimerResolution() {
        return implementation.getTimerResolution();
    }

    public static long getTime() {
        return implementation.getTime() & Long.MAX_VALUE;
    }

    static {
        Sys.loadLibrary("lwjgl");
        is64Bit = implementation.getPointerSize() == 8;
        int native_jni_version = implementation.getJNIVersion();
        int required_version = implementation.getRequiredJNIVersion();
        if (native_jni_version != required_version) {
            throw new LinkageError("Version mismatch: jar version is '" + required_version + "', native library version is '" + native_jni_version + "'");
        }
        implementation.setDebug(LWJGLUtil.DEBUG);
    }
}

