/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JFrame;

public interface FrameSetup {
    public void initialize(JFrame var1);

    public static class CenteredWithSize
    implements FrameSetup {
        private int frameWidth;
        private int frameHeight;
        private boolean shrunken;

        public CenteredWithSize(int n, int n2) {
            this.shrunken = this.getAvailableWidth() < n || this.getAvailableHeight() < n2;
            this.frameWidth = Math.min(this.getAvailableWidth(), n);
            this.frameHeight = Math.min(this.getAvailableHeight(), n2);
        }

        private int getAvailableWidth() {
            try {
                return Toolkit.getDefaultToolkit().getScreenSize().width - this.getInsets().left - this.getInsets().right;
            }
            catch (HeadlessException headlessException) {
                return 0;
            }
        }

        private int getAvailableHeight() {
            try {
                return Toolkit.getDefaultToolkit().getScreenSize().height - this.getInsets().top - this.getInsets().bottom;
            }
            catch (HeadlessException headlessException) {
                return 0;
            }
        }

        private Insets getInsets() {
            try {
                return Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            }
            catch (HeadlessException headlessException) {
                return new Insets(0, 0, 0, 0);
            }
        }

        private Rectangle getAvailableRectangle() {
            return new Rectangle(this.getInsets().left, this.getInsets().top, this.getAvailableWidth(), this.getAvailableHeight());
        }

        public void initialize(JFrame jFrame) {
            jFrame.setLocation((int)this.getAvailableRectangle().getCenterX() - this.frameWidth / 2, (int)this.getAvailableRectangle().getCenterY() - this.frameHeight / 2);
            jFrame.setSize(this.frameWidth, this.frameHeight);
        }
    }
}

