/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.module.betadecay.multinucleus.MultiNucleusBetaDecayModule;
import edu.colorado.phet.nuclearphysics.module.betadecay.singlenucleus.SingleNucleusBetaDecayModule;

public class BetaDecayApplication
extends PiccoloPhetApplication {
    private MultiNucleusBetaDecayModule _multiNucleusAlphaDecayModule;
    private SingleNucleusBetaDecayModule _singleNucleusAlphaDecayModule;

    public BetaDecayApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        PhetFrame phetFrame = this.getPhetFrame();
        this._multiNucleusAlphaDecayModule = new MultiNucleusBetaDecayModule(phetFrame);
        this.addModule(this._multiNucleusAlphaDecayModule);
        this._singleNucleusAlphaDecayModule = new SingleNucleusBetaDecayModule(phetFrame);
        this.addModule(this._singleNucleusAlphaDecayModule);
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new BetaDecayApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "nuclear-physics", "beta-decay");
        PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
        phetLookAndFeel.setBackgroundColor(NuclearPhysicsConstants.BETA_DECAY_CONTROL_PANEL_COLOR);
        phetApplicationConfig.setLookAndFeel(phetLookAndFeel);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

