/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common;

import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.util.ConstantPowerOfTenNumberFormat;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TimeDisplayNode
extends PNode {
    private final Color BACKGROUND_COLOR = new Color(255, 255, 255);
    private final Font TIME_FONT = new PhetFont(1, 26);
    private final float BORDER_STROKE_SIZE = 3.0f;
    private final double MILLISECONDS_PER_SECOND = 1000.0;
    private final double MILLISECONDS_PER_MINUTE = 60000.0;
    private final double MILLISECONDS_PER_HOUR = 3600000.0;
    private final double MILLISECONDS_PER_DAY = 8.64E7;
    private final double MILLISECONDS_PER_YEAR = 3.1536E10;
    private final double MILLISECONDS_PER_MILLENIUM = 3.1536E13;
    private final double MILLISECONDS_PER_MILLION_YEARS = 3.1536E16;
    private final double MILLISECONDS_PER_BILLION_YEARS = 3.1536E19;
    private final double MILLISECONDS_PER_TRILLION_YEARS = 3.1536E22;
    private final double MILLISECONDS_PER_QUADRILLION_YEARS = 3.1536E25;
    private final int EXPONENT_SCALE = 80;
    private final int NUM_SIGNIFICANT_DIGITS = 3;
    private double _width;
    private double _height;
    private PPath _background;
    private RoundRectangle2D _backgroundShape;
    private double _currentTimeInMilliseconds = Double.NEGATIVE_INFINITY;
    private double _displayedValue = Double.NEGATIVE_INFINITY;
    private HTMLNode _timeText;
    private HTMLNode _unitsText;
    private PText _spaceText;
    private HTMLNode _dummyTextNormal;
    private HTMLNode _dummyTextExponential;
    private NumberFormat _timeFormatterWithCommas = NumberFormat.getNumberInstance(PhetResources.readLocale());
    private DecimalFormat _timeFormatterNoDecimals = new DefaultDecimalFormat("##0");
    private DecimalFormat _timeFormatterOneDecimal = new DecimalFormat("##0.0");
    private DecimalFormat _timeFormatterTwoDecimals = new DecimalFormat("##0.00");
    private ConstantPowerOfTenNumberFormat _thousandsFormatter = new ConstantPowerOfTenNumberFormat("0", 3, 80);
    private ConstantPowerOfTenNumberFormat _millionsFormatter = new ConstantPowerOfTenNumberFormat("0", 6, 80);
    private ConstantPowerOfTenNumberFormat _billionsFormatter = new ConstantPowerOfTenNumberFormat("0", 9, 80);
    private ConstantPowerOfTenNumberFormat _trillionsFormatter = new ConstantPowerOfTenNumberFormat("0", 12, 80);
    private int _resolution = 0;

    public TimeDisplayNode(double d, double d2) {
        this._width = d;
        this._height = d2;
        this._backgroundShape = new RoundRectangle2D.Double(0.0, 0.0, this._width, this._height, this._width / 10.0, this._width / 10.0);
        this._background = new PPath(this._backgroundShape);
        this._background.setPaint(this.BACKGROUND_COLOR);
        this._background.setStroke(new BasicStroke(3.0f));
        this.addChild(this._background);
        this._timeText = new HTMLNode();
        this._timeText.setFont(this.TIME_FONT);
        this.addChild(this._timeText);
        this._spaceText = new PText(" ");
        this._spaceText.setFont(this.TIME_FONT);
        this.addChild(this._spaceText);
        this._unitsText = new HTMLNode();
        this._unitsText.setFont(this.TIME_FONT);
        this.addChild(this._unitsText);
        this._dummyTextNormal = new HTMLNode(this._timeFormatterNoDecimals.format(9999L));
        this._dummyTextNormal.setFont(this.TIME_FONT);
        this._dummyTextExponential = new HTMLNode(this._trillionsFormatter.format(9.99E14));
        this._dummyTextExponential.setFont(this.TIME_FONT);
    }

    private void updateTextScaling() {
        double d = this._height * 0.9;
        double d2 = this._width * 0.9;
        double d3 = 1.0;
        this._dummyTextNormal.setHTML(this._timeText.getHTML() + this._spaceText.getText() + this._unitsText.getHTML());
        double d4 = this._dummyTextNormal.getFullBoundsReference().width;
        double d5 = this._dummyTextNormal.getFullBoundsReference().height;
        if (d4 > d2) {
            d3 = d2 / d4;
        }
        if (d5 > d) {
            if (d / d5 < d3) {
                d3 = d / d5;
            }
            d3 = d2 / d4;
        }
        if ((int)(d3 * 100.0) != (int)(this._timeText.getScale() * 100.0)) {
            this._timeText.setScale(1.0);
            this._spaceText.setScale(1.0);
            this._unitsText.setScale(1.0);
            this._timeText.setScale(d3);
            this._spaceText.setScale(d3);
            this._unitsText.setScale(d3);
        }
    }

    public void setTime(double d) {
        if (d == this._currentTimeInMilliseconds) {
            return;
        }
        this._currentTimeInMilliseconds = d;
        double d2 = d / 3.1536E10;
        this._resolution = d2 < 1.0 ? -2 : (d2 < 1000000.0 ? 1 : 6);
        double d3 = this.roundToResolution(d2);
        if (d3 == this._displayedValue) {
            return;
        }
        this._displayedValue = d3;
        if (d3 < 1.0 && d3 != 0.0) {
            this._timeText.setHTML(this._timeFormatterTwoDecimals.format(d3));
        } else {
            this._timeText.setHTML(this._timeFormatterWithCommas.format(d3));
        }
        this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_YRS);
        this.updateTextScaling();
        this.updateTimeDisplay();
    }

    private double roundToResolution(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = d / Math.pow(10.0, this._resolution);
        d2 = Math.round(d2);
        return d2 *= Math.pow(10.0, this._resolution);
    }

    private void updateTimeDisplay() {
        double d = this._timeText.getFullBoundsReference().width + this._spaceText.getFullBoundsReference().width + this._unitsText.getFullBoundsReference().width;
        double d2 = Math.max(this._timeText.getFullBoundsReference().height, this._unitsText.getFullBoundsReference().height);
        double d3 = this._width / 2.0 - d / 2.0;
        double d4 = this._height / 2.0 - d2 / 2.0;
        this._timeText.setOffset(d3, d4);
        this._spaceText.setOffset(d3 + this._timeText.getFullBoundsReference().width, d4);
        this._unitsText.setOffset(d3 + this._timeText.getFullBoundsReference().width + this._spaceText.getFullBoundsReference().width, this._timeText.getFullBoundsReference().getMaxY() - this._unitsText.getFullBoundsReference().height);
    }
}

