/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common.view;

import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageType;
import edu.colorado.phet.nuclearphysics.common.view.LabeledExplodingAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import edu.colorado.phet.nuclearphysics.view.NucleusImageFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class AtomicNucleusImageNode
extends LabeledExplodingAtomicNucleusNode {
    private PNode _displayNode;
    private AtomicNucleusImageType _imageType;

    public AtomicNucleusImageNode(AtomicNucleus atomicNucleus, AtomicNucleusImageType atomicNucleusImageType, LabelVisibilityModel labelVisibilityModel) {
        super(atomicNucleus, labelVisibilityModel);
        this._imageType = atomicNucleusImageType;
        this._displayNode = this.createImage(atomicNucleus);
        this.addChild(0, this._displayNode);
    }

    private PNode createImage(AtomicNucleus atomicNucleus) {
        PNode pNode = null;
        if (this._imageType == AtomicNucleusImageType.NUCLEONS_VISIBLE) {
            pNode = NucleusImageFactory.getInstance().getNucleusImage(atomicNucleus.getNumProtons(), atomicNucleus.getNumNeutrons(), 25.0);
            pNode.scale(atomicNucleus.getDiameter() / 1.2 / ((pNode.getWidth() + pNode.getHeight()) / 2.0));
            pNode.setOffset(-pNode.getFullBoundsReference().width / 2.0, -pNode.getFullBoundsReference().height / 2.0);
        } else if (this._imageType == AtomicNucleusImageType.GRADIENT_SPHERE) {
            double d = atomicNucleus.getDiameter() / 2.0;
            RoundGradientPaint roundGradientPaint = new RoundGradientPaint(d, -d, Color.WHITE, new Point2D.Double(-d, d), this.getColorForElement(atomicNucleus));
            pNode = new SphericalNode(atomicNucleus.getDiameter(), roundGradientPaint, false);
        } else if (this._imageType == AtomicNucleusImageType.CIRCLE_WITH_HIGHLIGHT) {
            pNode = new PPath(new Ellipse2D.Double(0.0, 0.0, atomicNucleus.getDiameter(), -atomicNucleus.getDiameter() / 2.0));
            pNode.setPaint(this.getColorForElement(atomicNucleus));
        }
        return pNode;
    }

    protected void handleNucleusChangedEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
        super.handleNucleusChangedEvent(atomicNucleus, n, n2, arrayList);
        this.removeChild(this._displayNode);
        this._displayNode = this.createImage(atomicNucleus);
        this.addChild(0, this._displayNode);
    }

    private Color getColorForElement(AtomicNucleus atomicNucleus) {
        Color color;
        switch (atomicNucleus.getNumProtons()) {
            case 6: {
                color = NuclearPhysicsConstants.CARBON_COLOR;
                break;
            }
            case 7: {
                color = NuclearPhysicsConstants.NITROGEN_COLOR;
                break;
            }
            case 92: {
                color = NuclearPhysicsConstants.URANIUM_COLOR;
                break;
            }
            case 83: {
                color = NuclearPhysicsConstants.CUSTOM_NUCLEUS_PRE_DECAY_COLOR;
                break;
            }
            case 82: {
                color = NuclearPhysicsConstants.LEAD_COLOR;
                break;
            }
            case 81: {
                color = NuclearPhysicsConstants.CUSTOM_NUCLEUS_POST_DECAY_COLOR;
                break;
            }
            default: {
                System.out.println(this.getClass().getName() + "Warning: Don't have a color assignment for this element.");
                color = Color.BLACK;
            }
        }
        return color;
    }
}

