/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common.view;

import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class UnlabeledSphericalAtomicNucleusNode
extends AbstractAtomicNucleusNode {
    private int _currentNumProtons;
    private int _currentNumNeutrons;
    private SphericalNode _nucleusRepresentation;
    AtomicNucleus.Adapter _atomicNucleusAdapter = new AtomicNucleus.Adapter(){

        public void positionChanged() {
            UnlabeledSphericalAtomicNucleusNode.this.updatePosition();
        }

        public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
            UnlabeledSphericalAtomicNucleusNode.this.handleNucleusChangedEvent(atomicNucleus, n, n2, arrayList);
        }
    };

    public UnlabeledSphericalAtomicNucleusNode(AtomicNucleus atomicNucleus) {
        super(atomicNucleus);
        this._currentNumProtons = this._atomicNucleus.getNumProtons();
        this._currentNumNeutrons = this._atomicNucleus.getNumNeutrons();
        this._atomicNucleus.addListener(this._atomicNucleusAdapter);
        this.updateRepresentation2();
        this.addChild(this._nucleusRepresentation);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.updatePosition();
    }

    public AtomicNucleus getNucleusRef() {
        return this._atomicNucleus;
    }

    public void cleanup() {
        this._atomicNucleus.removeListener(this._atomicNucleusAdapter);
    }

    protected void handleNucleusChangedEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
        if (n != this._currentNumProtons || n2 != this._currentNumNeutrons) {
            this._currentNumProtons = n;
            this._currentNumNeutrons = n2;
            this.updateRepresentation2();
        } else {
            System.err.println(this.getClass().getName() + " - Error: Received notification of nucleus change but nothing appears to have changed.");
            assert (false);
        }
    }

    private void updateRepresentation2() {
        Color color = NucleusDisplayInfo.getDisplayInfoForNucleusConfig(this._currentNumProtons, this._currentNumNeutrons).getDisplayColor();
        double d = this._atomicNucleus.getDiameter() / 2.0;
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(d, -d, Color.WHITE, new Point2D.Double(-d, d), color);
        if (this._nucleusRepresentation == null) {
            this._nucleusRepresentation = new SphericalNode(d * 2.0, roundGradientPaint, true);
            this.addChild(this._nucleusRepresentation);
        } else {
            this._nucleusRepresentation.setDiameter(2.0 * d);
            this._nucleusRepresentation.setPaint(roundGradientPaint);
        }
    }
}

