/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.BetaDecayCompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import java.awt.geom.Point2D;

public class Carbon14CompositeNucleus
extends BetaDecayCompositeNucleus {
    private static double DECAY_TIME_SCALING_FACTOR = 700.0 / HalfLifeInfo.getHalfLifeForNucleusType(NucleusType.CARBON_14);

    public Carbon14CompositeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        super(nuclearPhysicsClock, point2D, 6, 8, DECAY_TIME_SCALING_FACTOR);
    }

    protected void updateAgitationFactor() {
        switch (this._numProtons) {
            case 6: {
                if (this._numNeutrons != 8) break;
                this._agitationFactor = 8;
                break;
            }
            case 7: {
                if (this._numNeutrons != 7) break;
                this._agitationFactor = 2;
                break;
            }
            default: {
                System.err.println("Error: Unexpected atomic weight in beta decay nucleus.");
                assert (false);
                break;
            }
        }
    }
}

