/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.AbstractBetaDecayNucleus;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import java.awt.geom.Point2D;

public class Carbon14Nucleus
extends AbstractBetaDecayNucleus {
    public static double HALF_LIFE = HalfLifeInfo.getHalfLifeForNucleusType(NucleusType.CARBON_14);
    private static double DECAY_TIME_SCALING_FACTOR = 1500.0 / HALF_LIFE;
    private boolean _enlarged = false;

    public Carbon14Nucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, boolean bl) {
        super(nuclearPhysicsClock, point2D, 6, 8, DECAY_TIME_SCALING_FACTOR);
        this._enlarged = bl;
    }

    public Carbon14Nucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        this(nuclearPhysicsClock, point2D, false);
    }

    public Carbon14Nucleus(NuclearPhysicsClock nuclearPhysicsClock) {
        this(nuclearPhysicsClock, new Point2D.Double(0.0, 0.0));
    }

    public void reset() {
        super.reset();
        if (this._numNeutrons != 8 || this._numProtons != 6) {
            this._numNeutrons = 8;
            this._numProtons = 6;
            this.notifyNucleusChangeEvent(null);
        }
    }

    public double getDiameter() {
        if (!this._enlarged) {
            return super.getDiameter();
        }
        return 1.6 * Math.pow(100.0, 0.362);
    }
}

