/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class ContainmentVessel {
    private double _originalRadius;
    private double _radius;
    private boolean _enabled;
    private Rectangle2D _apertureRect;
    private ArrayList _listeners;
    private int _cumulativeImpactAmount;
    private boolean _exploded;

    public ContainmentVessel(double d) {
        this._originalRadius = this._radius = d;
        this._enabled = false;
        this._exploded = false;
        this._listeners = new ArrayList();
        this._apertureRect = new Rectangle2D.Double();
        this.updateApertureRect();
    }

    public boolean getIsEnabled() {
        return this._enabled;
    }

    public boolean getIsExploded() {
        return this._exploded;
    }

    public void setIsEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
            this.notifiyEnableStateChanged();
            if (this._enabled) {
                this.resetImpactAccumulation();
                this.setRadius(this._originalRadius);
                this._exploded = false;
            }
        }
    }

    public double getRadius() {
        return this._radius;
    }

    public void setRadius(double d) {
        if (d > 15.0) {
            this._radius = d;
            this.notifiyRadiusChanged();
            this.updateApertureRect();
        }
    }

    public Rectangle2D getAperatureRectReference() {
        return this._apertureRect;
    }

    public void reset() {
        this.setRadius(this._originalRadius);
        this.setIsEnabled(false);
        this._exploded = false;
        this.resetImpactAccumulation();
        this.notifiyResetOccurred();
    }

    public void resetImpactAccumulation() {
        this._cumulativeImpactAmount = 0;
    }

    public boolean isPositionContained(Point2D point2D) {
        return this.isPositionContained(point2D.getX(), point2D.getY());
    }

    public boolean isPositionContained(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double();
        boolean bl = false;
        ((Point2D)double_).setLocation(d, d2);
        if (this._enabled && !this._exploded && double_.distance(0.0, 0.0) >= this._radius && double_.distance(0.0, 0.0) < this._radius + 10.0 && !this._apertureRect.contains(double_)) {
            bl = true;
        }
        return bl;
    }

    public void recordImpact(double d) {
        this._cumulativeImpactAmount = (int)((double)this._cumulativeImpactAmount + d);
        if (!this._exploded && (double)this._cumulativeImpactAmount > 1200.0) {
            this.explode();
        }
    }

    public Point2D getNearestContainmentPoint(Point2D point2D) {
        double d = Math.atan2(point2D.getY(), point2D.getX());
        return new Point2D.Double(Math.cos(d) * this._radius, Math.sin(d) * this._radius);
    }

    public void addListener(Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    private void explode() {
        this._exploded = true;
        this.notifiyExplosionOccurred();
    }

    private void updateApertureRect() {
        this._apertureRect.setFrame(-this._radius - 10.0, -9.0, 20.0, 18.0);
    }

    private void notifiyRadiusChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).radiusChanged(this._radius);
        }
    }

    private void notifiyEnableStateChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).enableStateChanged(this._enabled);
        }
    }

    private void notifiyExplosionOccurred() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).explosionOccurred();
        }
    }

    private void notifiyResetOccurred() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).resetOccurred();
        }
    }

    public static class Adapter
    implements Listener {
        public void radiusChanged(double d) {
        }

        public void enableStateChanged(boolean bl) {
        }

        public void explosionOccurred() {
        }

        public void resetOccurred() {
        }
    }

    public static interface Listener {
        public void radiusChanged(double var1);

        public void enableStateChanged(boolean var1);

        public void explosionOccurred();

        public void resetOccurred();
    }
}

