/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.BetaDecayCompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import java.awt.geom.Point2D;

public class LightAdjustableCompositeNucleus
extends BetaDecayCompositeNucleus {
    private static double DECAY_TIME_SCALING_FACTOR = 700.0 / HalfLifeInfo.getHalfLifeForNucleusType(NucleusType.LIGHT_CUSTOM);

    public LightAdjustableCompositeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        super(nuclearPhysicsClock, point2D, 8, 8, DECAY_TIME_SCALING_FACTOR);
    }

    protected void updateAgitationFactor() {
        switch (this._numProtons) {
            case 8: {
                this._agitationFactor = 8;
                break;
            }
            case 9: {
                this._agitationFactor = 2;
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + "Error: Unexpected atomic weight in beta decay nucleus.");
                assert (false);
                break;
            }
        }
    }
}

