/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.CompositeAtomicNucleus;
import edu.colorado.phet.nuclearphysics.model.DaughterCompositeNucleus;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Uranium235CompositeNucleus
extends CompositeAtomicNucleus {
    private double _fissionInterval;
    private double _fissionTime = 0.0;

    public Uranium235CompositeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, double d) {
        super(nuclearPhysicsClock, point2D, 92, 143, 1.0);
        this._fissionInterval = d;
        this.setTunnelingRegionRadius(this.getDiameter() / 2.0 * 1.1);
    }

    public boolean captureParticle(Nucleon nucleon) {
        boolean bl = false;
        if (this._numNeutrons == 143) {
            nucleon.setTunnelingEnabled(true);
            nucleon.setPosition(this.getPositionReference());
            nucleon.setVelocity(0.0, 0.0);
            this._constituents.add(nucleon);
            ++this._numNeutrons;
            this.updateAgitationFactor();
            this.notifyNucleusChangeEvent(null);
            this._fissionTime = this._clock.getSimulationTime() + this._fissionInterval;
            bl = true;
        }
        return bl;
    }

    public void reset(ArrayList arrayList, CompositeAtomicNucleus compositeAtomicNucleus) {
        int n;
        this._fissionTime = 0.0;
        this.setPosition(new Point2D.Double(0.0, 0.0));
        this.setVelocity(0.0, 0.0);
        this.setAcceleration(0.0, 0.0);
        if (this._numNeutrons < 143) {
            if (arrayList != null) {
                for (n = 0; n < 2; ++n) {
                    if (arrayList.size() >= 2) {
                        Nucleon nucleon = (Nucleon)arrayList.get(arrayList.size() - 1 - n);
                        nucleon.setVelocity(0.0, 0.0);
                        nucleon.setPosition(this._position);
                        nucleon.setTunnelingEnabled(true);
                        this._constituents.add(nucleon);
                        ++this._numNeutrons;
                        arrayList.remove(nucleon);
                        continue;
                    }
                    System.out.println("Error: Unexpected number of free neutrons on reset.");
                    assert (false);
                }
            }
            if (compositeAtomicNucleus != null) {
                ArrayList arrayList2 = compositeAtomicNucleus.getConstituents();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    Object e = arrayList2.get(i);
                    if (e instanceof AlphaParticle) {
                        ++this._numAlphas;
                        this._numProtons += 2;
                        this._numNeutrons += 2;
                    } else if (e instanceof Nucleon) {
                        if (((Nucleon)e).getNucleonType() == Nucleon.NucleonType.PROTON) {
                            ++this._numProtons;
                        } else {
                            ++this._numNeutrons;
                        }
                    } else assert (false);
                    this._constituents.add((SubatomicParticle)e);
                }
            }
        } else if (this._numNeutrons == 144) {
            for (int i = 0; i < this._constituents.size(); ++i) {
                if (!(this._constituents.get(i) instanceof Nucleon) || ((Nucleon)this._constituents.get(i)).getNucleonType() != Nucleon.NucleonType.NEUTRON) continue;
                arrayList.add(this._constituents.get(i));
                this._constituents.remove(i);
                --this._numNeutrons;
                break;
            }
        }
        for (n = 0; n < this._constituents.size(); ++n) {
            SubatomicParticle subatomicParticle = (SubatomicParticle)this._constituents.get(n);
            subatomicParticle.tunnel(this._position, 0.0, this.getDiameter() / 2.0, this._tunnelingRegionRadius);
        }
        this.updateAgitationFactor();
        this.notifyPositionChanged();
        this.notifyNucleusChangeEvent(null);
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        super.handleClockTicked(clockEvent);
        if (this._fissionTime != 0.0 && clockEvent.getSimulationTime() >= this._fissionTime) {
            Object object;
            int n;
            ArrayList arrayList = new ArrayList();
            int n2 = 0;
            for (n = 0; n < this._constituents.size() && n2 < 3; ++n) {
                if (!(this._constituents.get(n) instanceof Nucleon) || ((Nucleon)this._constituents.get(n)).getNucleonType() != Nucleon.NucleonType.NEUTRON) continue;
                Object e = this._constituents.get(n);
                arrayList.add(e);
                ++n2;
                --this._numNeutrons;
            }
            this._constituents.removeAll(arrayList);
            n = 12;
            int n3 = 12;
            int n4 = 32;
            ArrayList arrayList2 = new ArrayList(n + n3 + n4);
            for (int i = 0; i < this._constituents.size(); ++i) {
                object = this._constituents.get(i);
                if (n4 > 0 && object instanceof Nucleon && ((Nucleon)object).getNucleonType() == Nucleon.NucleonType.NEUTRON) {
                    arrayList2.add(object);
                    --n4;
                    --this._numNeutrons;
                } else if (n3 > 0 && object instanceof Nucleon && ((Nucleon)object).getNucleonType() == Nucleon.NucleonType.PROTON) {
                    arrayList2.add(object);
                    --n3;
                    --this._numProtons;
                }
                if (n > 0 && object instanceof AlphaParticle) {
                    arrayList2.add(object);
                    --n;
                    --this._numAlphas;
                    this._numNeutrons -= 2;
                    this._numProtons -= 2;
                }
                if (n4 == 0 && n3 == 0 && n == 0) break;
            }
            this._constituents.removeAll(arrayList2);
            Point2D.Double double_ = new Point2D.Double();
            double_.setLocation(this._position);
            object = new DaughterCompositeNucleus(this._clock, (Point2D)double_, arrayList2);
            arrayList.add(object);
            this.notifyNucleusChangeEvent(arrayList);
            this._fissionTime = 0.0;
        }
    }

    protected void updateAgitationFactor() {
        switch (this._numProtons) {
            case 92: {
                if (this._numNeutrons == 143) {
                    this._agitationFactor = 4;
                    break;
                }
                if (this._numNeutrons != 144) break;
                this._agitationFactor = 8;
                break;
            }
            default: {
                this._agitationFactor = 5;
            }
        }
    }
}

