/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.alphadecay.singlenucleus;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.common.view.AbstractAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.common.view.LabeledExplodingAtomicNucleusNode;
import edu.colorado.phet.nuclearphysics.model.AlphaDecayCompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.module.alphadecay.singlenucleus.SingleNucleusAlphaDecayModel;
import edu.colorado.phet.nuclearphysics.view.AlphaDecayEnergyChart;
import edu.colorado.phet.nuclearphysics.view.AlphaParticleModelNode;
import edu.colorado.phet.nuclearphysics.view.AutoPressButtonNode;
import edu.colorado.phet.nuclearphysics.view.NucleonModelNode;
import edu.colorado.phet.nuclearphysics.view.NucleonNode;
import edu.colorado.phet.nuclearphysics.view.SingleNucleusAlphaDecayTimeChart;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;

public class SingleNucleusAlphaDecayCanvas
extends PhetPCanvas {
    private final double CANVAS_WIDTH = 100.0;
    private final double CANVAS_HEIGHT = 75.0;
    private final double WIDTH_TRANSLATION_FACTOR = 0.5;
    private final double HEIGHT_TRANSLATION_FACTOR = 0.45;
    private final double TIME_CHART_FRACTION = 0.2;
    private final double ENERGY_CHART_FRACTION = 0.35;
    private final Color TUNNELING_MARKERS_COLOR = new Color(150, 0, 150);
    private SingleNucleusAlphaDecayModel _singleNucleusAlphaDecayModel;
    private AbstractAtomicNucleusNode _nucleusNode;
    private AlphaDecayEnergyChart _alphaDecayEnergyChart;
    private SingleNucleusAlphaDecayTimeChart _alphaDecayTimeChart;
    private AutoPressButtonNode _resetButtonNode;
    private PNode _nucleusLayer;
    private PNode _labelLayer;
    private PPath _tunnelingRegion;
    private PPath _leftTunnelingLine;
    private PPath _rightTunnelingLine;

    public SingleNucleusAlphaDecayCanvas(SingleNucleusAlphaDecayModel singleNucleusAlphaDecayModel) {
        this._singleNucleusAlphaDecayModel = singleNucleusAlphaDecayModel;
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(100.0, 75.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)SingleNucleusAlphaDecayCanvas.this.getWidth() * 0.5, (double)SingleNucleusAlphaDecayCanvas.this.getHeight() * 0.45);
            }
        });
        this._singleNucleusAlphaDecayModel.addListener(new NuclearDecayListenerAdapter(){

            public void modelElementAdded(Object object) {
                SingleNucleusAlphaDecayCanvas.this.createNucleusNodes();
                SingleNucleusAlphaDecayCanvas.this.positionTunnelingMarkers();
                if (object instanceof AtomicNucleus) {
                    ((AtomicNucleus)object).addListener(new AtomicNucleus.Adapter(){

                        public void tunnelingRadiusChanged() {
                            SingleNucleusAlphaDecayCanvas.this.positionTunnelingMarkers();
                        }
                    });
                }
            }

            public void modelElementRemoved(Object object) {
                if (object instanceof AlphaDecayCompositeNucleus) {
                    SingleNucleusAlphaDecayCanvas.this.removeNucleusNodes();
                }
            }
        });
        this._nucleusLayer = new PNode();
        this._nucleusLayer.setPickable(false);
        this._nucleusLayer.setChildrenPickable(false);
        this._nucleusLayer.setVisible(true);
        this.addWorldChild(this._nucleusLayer);
        this._labelLayer = new PNode();
        this.addWorldChild(this._labelLayer);
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        this._tunnelingRegion = new PPath();
        this._tunnelingRegion.setStroke(new BasicStroke(0.1f, 0, 2, 0.0f, new float[]{0.75f, 0.75f}, 0.0f));
        this._tunnelingRegion.setStrokePaint(this.TUNNELING_MARKERS_COLOR);
        this.addWorldChild(this._tunnelingRegion);
        this._alphaDecayEnergyChart = new AlphaDecayEnergyChart(singleNucleusAlphaDecayModel, this);
        this.addScreenChild(this._alphaDecayEnergyChart);
        this._leftTunnelingLine = new PPath(new Line2D.Double(0.0, 0.0, 0.0, 26.25));
        this._leftTunnelingLine.setStroke(new BasicStroke(0.1f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f));
        this._leftTunnelingLine.setStrokePaint(this.TUNNELING_MARKERS_COLOR);
        this.addWorldChild(this._leftTunnelingLine);
        this._rightTunnelingLine = new PPath(new Line2D.Double(0.0, 0.0, 0.0, 26.25));
        this._rightTunnelingLine.setStroke(new BasicStroke(0.1f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f));
        this._rightTunnelingLine.setStrokePaint(this.TUNNELING_MARKERS_COLOR);
        this.addWorldChild(this._rightTunnelingLine);
        this._resetButtonNode = new AutoPressButtonNode(NuclearPhysicsStrings.RESET_NUCLEUS, 22, NuclearPhysicsConstants.CANVAS_RESET_BUTTON_COLOR);
        this.addScreenChild(this._resetButtonNode);
        this._resetButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleNucleusAlphaDecayCanvas.this._singleNucleusAlphaDecayModel.resetNucleus();
            }
        });
        this._alphaDecayTimeChart = new SingleNucleusAlphaDecayTimeChart(this._singleNucleusAlphaDecayModel);
        this.addScreenChild(this._alphaDecayTimeChart);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, SingleNucleusAlphaDecayCanvas.this.getWidth(), (double)SingleNucleusAlphaDecayCanvas.this.getHeight() * 0.35);
                SingleNucleusAlphaDecayCanvas.this._alphaDecayEnergyChart.componentResized(double_);
                SingleNucleusAlphaDecayCanvas.this._alphaDecayEnergyChart.setOffset(0.0, (double)SingleNucleusAlphaDecayCanvas.this.getHeight() - ((SingleNucleusAlphaDecayCanvas)SingleNucleusAlphaDecayCanvas.this)._alphaDecayEnergyChart.getFullBoundsReference().height - 4.0);
                SingleNucleusAlphaDecayCanvas.this._alphaDecayTimeChart.componentResized(new Rectangle2D.Double(0.0, 0.0, SingleNucleusAlphaDecayCanvas.this.getWidth(), (double)SingleNucleusAlphaDecayCanvas.this.getHeight() * 0.2));
                SingleNucleusAlphaDecayCanvas.this._alphaDecayTimeChart.setOffset(0.0, 0.0);
                SingleNucleusAlphaDecayCanvas.this._resetButtonNode.setOffset(0.82 * (double)SingleNucleusAlphaDecayCanvas.this.getWidth() - ((SingleNucleusAlphaDecayCanvas)SingleNucleusAlphaDecayCanvas.this)._resetButtonNode.getFullBoundsReference().width / 2.0, 0.3 * (double)SingleNucleusAlphaDecayCanvas.this.getHeight());
            }
        });
    }

    public void autoPressResetButton() {
        this._resetButtonNode.autoPress();
    }

    private void positionTunnelingMarkers() {
        AlphaDecayCompositeNucleus alphaDecayCompositeNucleus = this._singleNucleusAlphaDecayModel.getAtomNucleus();
        if (alphaDecayCompositeNucleus != null) {
            double d = alphaDecayCompositeNucleus.getTunnelingRegionRadius();
            if (d < 100.0) {
                this._leftTunnelingLine.setOffset(-d, 0.0);
                this._leftTunnelingLine.setVisible(true);
                this._rightTunnelingLine.setOffset(d, 0.0);
                this._rightTunnelingLine.setVisible(true);
                this._tunnelingRegion.setPathTo(new Ellipse2D.Double(0.0, 0.0, d * 2.0, d * 2.0));
                this._tunnelingRegion.setOffset(-d, -d);
                this._tunnelingRegion.setVisible(true);
            } else {
                this._leftTunnelingLine.setVisible(false);
                this._rightTunnelingLine.setVisible(false);
                this._tunnelingRegion.setVisible(false);
            }
        }
    }

    private void createNucleusNodes() {
        AlphaDecayCompositeNucleus alphaDecayCompositeNucleus = this._singleNucleusAlphaDecayModel.getAtomNucleus();
        ArrayList arrayList = alphaDecayCompositeNucleus.getConstituents();
        for (int i = 0; i < arrayList.size(); ++i) {
            PNode pNode;
            Object e = arrayList.get(i);
            if (e instanceof AlphaParticle) {
                pNode = new AlphaParticleModelNode((AlphaParticle)e);
                pNode.setVisible(true);
                this._nucleusLayer.addChild(pNode);
                continue;
            }
            if (e instanceof Nucleon) {
                pNode = new NucleonNode((Nucleon)e);
                pNode.setVisible(true);
                this._nucleusLayer.addChild(pNode);
                continue;
            }
            assert (false);
        }
        this._nucleusNode = new LabeledExplodingAtomicNucleusNode(alphaDecayCompositeNucleus);
        this._labelLayer.addChild(this._nucleusNode);
    }

    private void removeNucleusNodes() {
        Object object2;
        Collection collection = this._nucleusLayer.getAllNodes();
        for (Object object2 : collection) {
            if (object2 instanceof AlphaParticleModelNode) {
                ((AlphaParticleModelNode)object2).cleanup();
                continue;
            }
            if (!(object2 instanceof NucleonModelNode)) continue;
            ((NucleonModelNode)object2).cleanup();
        }
        object2 = this._labelLayer.getAllNodes();
        for (Object e : object2) {
            if (!(e instanceof LabeledExplodingAtomicNucleusNode)) continue;
            ((AbstractAtomicNucleusNode)e).cleanup();
        }
        this._nucleusLayer.removeAllChildren();
        this._labelLayer.removeAllChildren();
    }
}

