/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.fissiononenucleus;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusImageNode;
import edu.colorado.phet.nuclearphysics.view.StandaloneNeutronNode;
import edu.colorado.phet.nuclearphysics.view.StandaloneProtonNode;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class FissionOneNucleusLegendPanel
extends JPanel {
    public FissionOneNucleusLegendPanel() {
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NuclearPhysicsStrings.LEGEND_BORDER_LABEL, 1, 2, new PhetFont(1, 14), Color.GRAY);
        this.setBorder(titledBorder);
        this.setLayout(new GridLayout(0, 2));
        StandaloneNeutronNode standaloneNeutronNode = new StandaloneNeutronNode();
        standaloneNeutronNode.scale(8.0);
        this.addLegendItem(standaloneNeutronNode.toImage(), NuclearPhysicsStrings.NEUTRON_LEGEND_LABEL);
        StandaloneProtonNode standaloneProtonNode = new StandaloneProtonNode();
        standaloneProtonNode.scale(8.0);
        this.addLegendItem(standaloneProtonNode.toImage(), NuclearPhysicsStrings.PROTON_LEGEND_LABEL);
        LabeledNucleusImageNode labeledNucleusImageNode = new LabeledNucleusImageNode("uranium-nucleus-small.png", NuclearPhysicsStrings.URANIUM_235_ISOTOPE_NUMBER, NuclearPhysicsStrings.URANIUM_235_CHEMICAL_SYMBOL, NuclearPhysicsConstants.URANIUM_235_LABEL_COLOR);
        Image image = labeledNucleusImageNode.toImage();
        ImageIcon imageIcon = new ImageIcon(image);
        this.add(new JLabel(imageIcon));
        this.add(new JLabel(NuclearPhysicsStrings.URANIUM_235_LEGEND_LABEL));
        this.addLegendItem("daughter-nuclei-small.png", NuclearPhysicsStrings.DAUGHTER_NUCLEI_LABEL, 75);
    }

    private void addLegendItem(String string, String string2, int n) {
        BufferedImage bufferedImage = NuclearPhysicsResources.getImage(string);
        ImageIcon imageIcon = new ImageIcon(bufferedImage.getScaledInstance(n, -1, 4));
        this.add(new JLabel(imageIcon));
        this.add(new JLabel(string2));
    }

    private void addLegendItem(Image image, String string) {
        ImageIcon imageIcon = new ImageIcon(image);
        this.add(new JLabel(imageIcon));
        this.add(new JLabel(string));
    }
}

