/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.halflife;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.NucleusTypeControl;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusSphereNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class IsotopeSelectionControlPanel
extends ControlPanel {
    private IsotopeSelectionPanel _selectionPanel;
    private NucleusTypeControl _model;
    private static final Font LABEL_FONT = new PhetFont(1, 14);

    public IsotopeSelectionControlPanel(PiccoloModule piccoloModule, Frame frame, NucleusTypeControl nucleusTypeControl, boolean bl) {
        this._model = nucleusTypeControl;
        int n = NuclearPhysicsResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        this._selectionPanel = new IsotopeSelectionPanel(bl);
        this.addControlFullWidth(this._selectionPanel);
        this.addVerticalSpace(10);
        this.addResetAllButton(piccoloModule);
    }

    private class IsotopeSelectionPanel
    extends JPanel {
        private JRadioButton _carbon14RadioButton;
        private JRadioButton _uranium238RadioButton;
        private JRadioButton _customNucleusRadioButton;
        private int _isotopeSelectorCount = 0;

        public IsotopeSelectionPanel(boolean bl) {
            IsotopeSelectionControlPanel.this._model.addListener(new NuclearDecayListenerAdapter(){

                public void nucleusTypeChanged() {
                    if (IsotopeSelectionControlPanel.this._model.getNucleusType() == NucleusType.CARBON_14) {
                        IsotopeSelectionPanel.this._carbon14RadioButton.setSelected(true);
                    } else if (IsotopeSelectionControlPanel.this._model.getNucleusType() == NucleusType.URANIUM_238) {
                        IsotopeSelectionPanel.this._uranium238RadioButton.setSelected(true);
                    } else {
                        IsotopeSelectionPanel.this._customNucleusRadioButton.setSelected(true);
                    }
                }
            });
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NuclearPhysicsStrings.ISOTOPE_SELECTION_BORDER_LABEL, 1, 2, new PhetFont(1, 14), Color.GRAY);
            this.setBorder(titledBorder);
            this.setLayout(new GridBagLayout());
            this._carbon14RadioButton = new JRadioButton();
            this._uranium238RadioButton = new JRadioButton();
            this._customNucleusRadioButton = new JRadioButton();
            this._carbon14RadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IsotopeSelectionControlPanel.this._model.setNucleusType(NucleusType.CARBON_14);
                }
            });
            this._uranium238RadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IsotopeSelectionControlPanel.this._model.setNucleusType(NucleusType.URANIUM_238);
                }
            });
            this._customNucleusRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IsotopeSelectionControlPanel.this._model.setNucleusType(NucleusType.HEAVY_CUSTOM);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._carbon14RadioButton);
            buttonGroup.add(this._uranium238RadioButton);
            buttonGroup.add(this._customNucleusRadioButton);
            this._carbon14RadioButton.setSelected(true);
            this.addIsotopeSelection(this._carbon14RadioButton, NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.CARBON_14), NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.NITROGEN_14));
            this.addIsotopeSelection(this._uranium238RadioButton, NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.URANIUM_238), NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.LEAD_206));
            if (bl) {
                this.addIsotopeSelection(this._customNucleusRadioButton, NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.HEAVY_CUSTOM), NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.HEAVY_CUSTOM_POST_DECAY));
            }
        }

        private void addIsotopeSelection(final JRadioButton jRadioButton, NucleusDisplayInfo nucleusDisplayInfo, NucleusDisplayInfo nucleusDisplayInfo2) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this._isotopeSelectorCount * 4;
            gridBagConstraints.ipadx = 25;
            this.add((Component)jRadioButton, gridBagConstraints);
            gridBagConstraints.ipadx = 0;
            LabeledNucleusSphereNode labeledNucleusSphereNode = new LabeledNucleusSphereNode(nucleusDisplayInfo);
            Image image = labeledNucleusSphereNode.toImage();
            ImageIcon imageIcon = new ImageIcon(image);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this._isotopeSelectorCount * 4;
            gridBagConstraints.ipadx = 10;
            JLabel jLabel = new JLabel(imageIcon);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.ipadx = 0;
            jLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    jRadioButton.doClick();
                }
            });
            JLabel jLabel2 = new JLabel(nucleusDisplayInfo.getName());
            jLabel2.setFont(LABEL_FONT);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = this._isotopeSelectorCount * 4;
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this._isotopeSelectorCount * 4 + 1;
            this.add((Component)new JLabel(this.createArrowIcon(Color.BLACK)), gridBagConstraints);
            LabeledNucleusSphereNode labeledNucleusSphereNode2 = new LabeledNucleusSphereNode(nucleusDisplayInfo2);
            Image image2 = labeledNucleusSphereNode2.toImage();
            ImageIcon imageIcon2 = new ImageIcon(image2);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this._isotopeSelectorCount * 4 + 2;
            gridBagConstraints.ipadx = 10;
            JLabel jLabel3 = new JLabel(imageIcon2);
            this.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.ipadx = 0;
            jLabel3.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    jRadioButton.doClick();
                }
            });
            JLabel jLabel4 = new JLabel(nucleusDisplayInfo2.getName());
            jLabel4.setFont(LABEL_FONT);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = this._isotopeSelectorCount * 4 + 2;
            this.add((Component)jLabel4, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this._isotopeSelectorCount * 4 + 3;
            this.add((Component)this.createVerticalSpacingPanel(20), gridBagConstraints);
            ++this._isotopeSelectorCount;
        }

        private ImageIcon createArrowIcon(Color color) {
            ArrowNode arrowNode = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 15.0), 8.0, 14.0, 6.0);
            arrowNode.setPaint(color);
            Image image = arrowNode.toImage();
            return new ImageIcon(image);
        }

        private JPanel createVerticalSpacingPanel(int n) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(Box.createVerticalStrut(n));
            return jPanel;
        }
    }
}

