/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedDatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricClosureState;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Random;

public class AgingTree
extends AnimatedDatableItem {
    private static final double AGE_OF_NATURAL_DEATH = HalfLifeInfo.convertYearsToMs(1000.0);
    private static final Random RAND = new Random();
    private boolean _closurePossibleSent = false;
    private int _fadeCounter = 30;
    private int _swayCounter = 30;
    private int _fallCounter = 30;
    private int _bounceCounter = 9;
    private double _previousAngle;

    public AgingTree(ConstantDtClock constantDtClock, Point2D point2D, double d, double d2) {
        super("Aging Tree", Arrays.asList("tree_1.png", "tree_dead_3.png"), point2D, d, 0.0, 0.0, constantDtClock, d2, true);
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        super.handleClockTicked(clockEvent);
        this.animate(this.getTotalAge());
    }

    private void animate(double d) {
        Dimension2D dimension2D;
        if (!this._closurePossibleSent) {
            this.setClosureState(RadiometricClosureState.CLOSURE_POSSIBLE);
            this._closurePossibleSent = true;
        }
        if ((dimension2D = this.getSize()).getHeight() < 22.0 && this.getClosureState() != RadiometricClosureState.CLOSED) {
            this.setSize(new PDimension(dimension2D.getWidth() * 1.03, dimension2D.getHeight() * 1.03));
            Point2D point2D = this.getPosition();
            this.setPosition(point2D.getX(), point2D.getY() + dimension2D.getHeight() * 0.012);
        }
        if (this.getClosureState() != RadiometricClosureState.CLOSED && d > AGE_OF_NATURAL_DEATH && this._fadeCounter > 0) {
            double d2 = 0.03333333333333333;
            this.setFadeFactor(Math.min(this.getFadeFactor() + d2, 1.0));
            --this._fadeCounter;
            if (this._fadeCounter == 0) {
                this.setClosureState(RadiometricClosureState.CLOSED);
            }
        }
        if (this.getClosureState() == RadiometricClosureState.CLOSED) {
            this.setFadeFactor(1.0);
            if (this._swayCounter > 0) {
                double d3 = Math.cos((double)(this._swayCounter - 30) / 30.0 * Math.PI * 2.0) * 0.01;
                this.rotateAboutBottomCenter(d3);
                --this._swayCounter;
            } else if (this._fallCounter > 0) {
                this.rotateAboutBottomCenter(0.003490658503988659 * (double)(30 - this._fallCounter));
                if (this._fallCounter < 15) {
                    this.setPosition(this.getPosition().getX() - this.getSize().getWidth() * 0.015, this.getPosition().getY() + this.getSize().getHeight() * 0.005);
                }
                --this._fallCounter;
            } else if (this._bounceCounter > 0) {
                double d4 = -Math.sin((double)(this._bounceCounter - 9) / 9.0 * Math.PI * 2.0) * (0.01 * this.getSize().getWidth());
                this.setPosition(this.getPosition().getX(), this.getPosition().getY() + d4);
                if ((9 - this._bounceCounter) % 4 == 0) {
                    this._previousAngle = this.getRotationalAngle();
                    this.setRotationalAngle(this._previousAngle + RAND.nextDouble() * Math.PI / 24.0);
                } else if ((9 - this._bounceCounter) % 2 == 0) {
                    this.setRotationalAngle(this._previousAngle);
                }
                --this._bounceCounter;
            }
        }
    }

    private void rotateAboutBottomCenter(double d) {
        double d2 = this.getSize().getHeight() * Math.sin(d / 2.0);
        double d3 = this.getRotationalAngle() + d / 2.0;
        double d4 = d2 * Math.cos(d3);
        double d5 = -d2 * Math.sin(d3);
        this.setRotationalAngle(this.getRotationalAngle() + d);
        this.setPosition(this.getPosition().getX() + d4, this.getPosition().getY() + d5);
    }
}

