/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.audio.AudioResourcePlayer;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AgeGuessResultNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AgeGuessingNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItemNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.EdgeOfWorldNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadioactiveDatingGameModel;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricDatingMeter;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricDatingMeterNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.SkyNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.StratumNode;
import edu.colorado.phet.nuclearphysics.view.NuclearDecayProportionChart;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class RadioactiveDatingGameCanvas
extends PhetPCanvas {
    private static final Dimension INITIAL_INTERMEDIATE_DIMENSION = new Dimension(786, 786);
    private static final Color RESET_GUESSES_BUTTON_COLOR = new Color(0xFF9900);
    private ModelViewTransform2D _mvt;
    private RadioactiveDatingGameModel _model;
    private PNode _backgroundImageLayer;
    private PNode _backgroundImage;
    private PNode _strataLayer;
    private PNode _guessingGameLayer;
    private AgeGuessingNode _ageGuessingNode;
    private NuclearDecayProportionChart _proportionsChart;
    private RadiometricDatingMeterNode _meterNode;
    private ArrayList<StratumNode> _stratumNodes = new ArrayList();
    private EdgeOfWorldNode _edgeOfWorld;
    private IdentityHashMap<DatableItem, PNode> _mapDatableItemsToNodes = new IdentityHashMap();
    private IdentityHashMap<DatableItem, AgeGuessResultNode> _mapDatableItemsToGuessResults = new IdentityHashMap();
    private AgeGuessingNode.Listener _ageGuessListener;
    private HTMLImageButtonNode _resetGuessesButtonNode;
    private PPath _transformedViewportBounds = new PPath();
    private AgeGuessResultNode.Listener _clearResultListener;
    private AudioResourcePlayer _audioResourcePlayer;

    public RadioactiveDatingGameCanvas(RadioactiveDatingGameModel radioactiveDatingGameModel, AudioResourcePlayer audioResourcePlayer) {
        this._model = radioactiveDatingGameModel;
        this._audioResourcePlayer = audioResourcePlayer;
        this.setWorldTransformStrategy(new PhetPCanvas.CenterWidthScaleHeight(this, INITIAL_INTERMEDIATE_DIMENSION));
        this._mvt = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point(393, (int)Math.round(432.3)), 20.0, true);
        this._model.getMeter().addListener(new RadiometricDatingMeter.Adapter(){

            public void datingElementChanged() {
                RadioactiveDatingGameCanvas.this._proportionsChart.clear();
                RadioactiveDatingGameCanvas.this.configureProportionsChart();
                RadioactiveDatingGameCanvas.this.drawDecayCurveOnChart();
                RadioactiveDatingGameCanvas.this.update();
            }
        });
        this._model.getMeter().addListener(new RadiometricDatingMeter.Adapter(){

            public void touchedStateChanged() {
                RadioactiveDatingGameCanvas.this.handleMeterTouchStateChanged();
            }
        });
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        this._backgroundImageLayer = new PNode();
        this.addWorldChild(this._backgroundImageLayer);
        this._strataLayer = new PNode();
        this.addWorldChild(this._strataLayer);
        this._guessingGameLayer = new PNode();
        this.addWorldChild(this._guessingGameLayer);
        SkyNode skyNode = new SkyNode(3144.0, 1179.0);
        skyNode.setOffset(this._mvt.modelToViewXDouble(0.0), this._mvt.modelToViewYDouble(0.0));
        this._backgroundImageLayer.addChild(skyNode);
        PImage pImage = NuclearPhysicsResources.getImageNode("cloud_1.png");
        pImage.setScale(0.65);
        pImage.setOffset(-200.0, 100.0);
        this._backgroundImageLayer.addChild(pImage);
        PImage pImage2 = NuclearPhysicsResources.getImageNode("cloud_1.png");
        pImage2.setScale(0.4);
        pImage2.setOffset(700.0, 270.0);
        this._backgroundImageLayer.addChild(pImage2);
        BufferedImage bufferedImage = NuclearPhysicsResources.getImage("dating_tab_background_only_ground.png");
        this._backgroundImage = new PImage(bufferedImage);
        this._backgroundImage.scale(1.2);
        this._backgroundImage.setOffset(393.0 - this._backgroundImage.getFullBoundsReference().width / 2.0, this._mvt.modelToViewYDouble(-0.25) - this._backgroundImage.getFullBoundsReference().height);
        this._backgroundImageLayer.addChild(this._backgroundImage);
        for (int i = 0; i < this._model.getLayerCount(); ++i) {
            StratumNode object = new StratumNode(this._model.getLayer(i), NuclearPhysicsConstants.strataColors.get(i % NuclearPhysicsConstants.strataColors.size()), this._mvt);
            this._stratumNodes.add(object);
            this._strataLayer.addChild(object);
        }
        for (DatableItem datableItem : this._model.getItemIterable()) {
            DatableItemNode datableItemNode = new DatableItemNode(datableItem, this._mvt);
            this._mapDatableItemsToNodes.put(datableItem, datableItemNode);
            this._strataLayer.addChild(datableItemNode);
        }
        this._edgeOfWorld = new EdgeOfWorldNode(this._model, this._mvt);
        this.addWorldChild(this._edgeOfWorld);
        this._proportionsChart = new NuclearDecayProportionChart(false, true, false, true);
        this.configureProportionsChart();
        this.addWorldChild(this._proportionsChart);
        this._meterNode = new RadiometricDatingMeterNode(this._model.getMeter(), 180.78, 251.52, this._mvt, this, true, this._transformedViewportBounds);
        this._meterNode.setMeterBodyOffset(0.0, 8.0);
        this.addWorldChild(this._meterNode);
        this._proportionsChart.componentResized(new Rectangle2D.Double(0.0, 0.0, 707.4, 251.52));
        this._proportionsChart.setOffset(190.78, 8.0);
        this._resetGuessesButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.RESET_GUESSES, new PhetFont(1, 30), RESET_GUESSES_BUTTON_COLOR);
        this._resetGuessesButtonNode.setOffset(this._proportionsChart.getFullBoundsReference().getMaxX() - this._resetGuessesButtonNode.getFullBoundsReference().width, this._proportionsChart.getFullBoundsReference().getMaxY() + 10.0);
        this._resetGuessesButtonNode.setVisible(false);
        this._resetGuessesButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RadioactiveDatingGameCanvas.this.clearGuessResults();
                RadioactiveDatingGameCanvas.this._resetGuessesButtonNode.setVisible(false);
            }
        });
        this.addWorldChild(this._resetGuessesButtonNode);
        this.drawDecayCurveOnChart();
        this._ageGuessListener = new AgeGuessingNode.Listener(){

            public void guessSubmitted(double d) {
                RadioactiveDatingGameCanvas.this.handleGuessSubmitted(d);
            }
        };
        this.addWorldChild(this._transformedViewportBounds);
        this._clearResultListener = new AgeGuessResultNode.Listener(){

            public void userCleared(AgeGuessResultNode ageGuessResultNode) {
                RadioactiveDatingGameCanvas.this.clearGuessResult(ageGuessResultNode);
            }
        };
    }

    public void updateLayout() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            AffineTransform affineTransform;
            Point2D.Double double_;
            Point2D.Double double_2;
            block5: {
                Point2D.Double double_3 = new Point2D.Double((double)this.getWidth() * 0.05, 0.0);
                Point2D.Double double_4 = new Point2D.Double(0.0, 0.0);
                double_2 = new Point2D.Double();
                double_ = new Point2D.Double();
                AffineTransform affineTransform2 = this.getWorldTransformStrategy().getTransform();
                try {
                    affineTransform2.inverseTransform(double_3, double_2);
                    affineTransform2.inverseTransform(double_4, double_);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    System.err.println("Error: Unable to invert transform.");
                    noninvertibleTransformException.printStackTrace();
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            this._edgeOfWorld.updateEdgeShape(((Point2D)double_2).getX(), ((Point2D)double_).getX());
            AffineTransform affineTransform3 = this.getWorldTransformStrategy().getTransform();
            try {
                affineTransform = affineTransform3.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println(this.getClass().getName() + " - Error: Unable to invert transform.");
                noninvertibleTransformException.printStackTrace();
                affineTransform = new AffineTransform();
            }
            Shape shape = affineTransform.createTransformedShape(this.getBounds());
            this._transformedViewportBounds.setPathTo(shape);
        }
    }

    private void drawDecayCurveOnChart() {
        double d = this._model.getMeter().getHalfLifeForDating();
        this._proportionsChart.clear();
        double d2 = d * 3.2;
        double d3 = d2 / 500.0;
        double d4 = Math.log(2.0) / d;
        for (double d5 = 0.0; d5 < d2; d5 += d3) {
            double d6 = Math.exp(-d5 * d4) * 100.0;
            this._proportionsChart.addDataPoint(d5, d6);
        }
        this._proportionsChart.updateMarkerText();
    }

    private void clearGuessResult(AgeGuessResultNode ageGuessResultNode) {
        if (!this._guessingGameLayer.isAncestorOf(ageGuessResultNode)) {
            System.err.println(this.getClass().getName() + " - Error: Guessing node not found.");
            return;
        }
        this._guessingGameLayer.removeChild(ageGuessResultNode);
        DatableItem datableItem = null;
        Object object = this._mapDatableItemsToGuessResults.keySet().iterator();
        while (object.hasNext()) {
            DatableItem datableItem2 = object.next();
            if (!this._mapDatableItemsToGuessResults.get(datableItem2).equals(ageGuessResultNode)) continue;
            datableItem = datableItem2;
            break;
        }
        if (datableItem != null) {
            this._mapDatableItemsToGuessResults.remove(datableItem);
        }
        if (this._mapDatableItemsToGuessResults.isEmpty()) {
            this._resetGuessesButtonNode.setVisible(false);
        }
        if ((object = this._model.getMeter().getItemBeingTouched()) == datableItem && this._ageGuessingNode == null) {
            this.displayAgeGuessNode((DatableItem)object);
        }
    }

    private void handleMeterTouchStateChanged() {
        DatableItem datableItem;
        if (this._ageGuessingNode != null) {
            this._guessingGameLayer.removeChild(this._ageGuessingNode);
            this._ageGuessingNode.removeListener(this._ageGuessListener);
            this._ageGuessingNode = null;
        }
        if ((datableItem = this._model.getMeter().getItemBeingTouched()) != null && datableItem != this._model.getDatableAir()) {
            AgeGuessResultNode ageGuessResultNode = this._mapDatableItemsToGuessResults.get(datableItem);
            if (ageGuessResultNode != null) {
                if (ageGuessResultNode.isGuessGood()) {
                    return;
                }
                ageGuessResultNode.setVisible(false);
            }
            this.displayAgeGuessNode(datableItem);
        } else {
            for (AgeGuessResultNode ageGuessResultNode : this._mapDatableItemsToGuessResults.values()) {
                ageGuessResultNode.setVisible(true);
            }
        }
    }

    private void displayAgeGuessNode(DatableItem datableItem) {
        this._ageGuessingNode = new AgeGuessingNode(datableItem);
        PNode pNode = this._mapDatableItemsToNodes.get(datableItem);
        Point2D point2D = new Point2D.Double(0.0, 0.0);
        if (pNode == null) {
            System.err.println(this.getClass().getName() + " - Error: Could not locate node for datable item " + datableItem);
            assert (false);
            return;
        }
        point2D = this.findSpotForWindow(pNode.getFullBounds(), this._ageGuessingNode.getFullBounds());
        this._ageGuessingNode.setOffset(point2D);
        this._guessingGameLayer.addChild(this._ageGuessingNode);
        this._ageGuessingNode.requestFocus();
        this._ageGuessingNode.addListener(new AgeGuessingNode.Listener(){

            public void guessSubmitted(double d) {
                RadioactiveDatingGameCanvas.this.handleGuessSubmitted(d);
            }
        });
    }

    private void handleGuessSubmitted(double d) {
        DatableItem datableItem = this._model.getMeter().getItemBeingTouched();
        if (datableItem == null) {
            System.err.println(this.getClass().getName() + " - Error: Guess submitted when meter not it contact with datable item.");
            assert (false);
            return;
        }
        this._ageGuessingNode.removeListener(this._ageGuessListener);
        this._guessingGameLayer.removeChild(this._ageGuessingNode);
        this._ageGuessingNode = null;
        if (!(d >= 0.0) || !(d < Double.POSITIVE_INFINITY)) {
            AgeGuessResultNode ageGuessResultNode = this._mapDatableItemsToGuessResults.get(datableItem);
            if (ageGuessResultNode != null) {
                ageGuessResultNode.setVisible(true);
            }
            return;
        }
        AgeGuessResultNode ageGuessResultNode = this._mapDatableItemsToGuessResults.remove(datableItem);
        if (ageGuessResultNode != null) {
            this._guessingGameLayer.removeChild(ageGuessResultNode);
        }
        AgeGuessResultNode ageGuessResultNode2 = new AgeGuessResultNode(d, this.determineIfGuessIsGood(HalfLifeInfo.convertYearsToMs(d), datableItem));
        this._mapDatableItemsToGuessResults.put(datableItem, ageGuessResultNode2);
        ageGuessResultNode2.addListener(this._clearResultListener);
        if (this.determineIfGuessIsGood(HalfLifeInfo.convertYearsToMs(d), datableItem)) {
            this._audioResourcePlayer.playSimAudio("ding.wav");
        } else {
            this._audioResourcePlayer.playSimAudio("32_83.wav");
        }
        PNode pNode = this._mapDatableItemsToNodes.get(datableItem);
        ageGuessResultNode2.setOffset(this.findSpotForWindow(pNode.getFullBounds(), ageGuessResultNode2.getFullBounds()));
        this._guessingGameLayer.addChild(ageGuessResultNode2);
        if (this._mapDatableItemsToGuessResults.size() > 0) {
            this._resetGuessesButtonNode.setVisible(true);
        }
        boolean bl = true;
        for (DatableItem datableItem2 : this._model.getItemIterable()) {
            if (this._mapDatableItemsToGuessResults.containsKey(datableItem2)) {
                if (this._mapDatableItemsToGuessResults.get(datableItem2).isGuessGood()) continue;
                bl = false;
                break;
            }
            bl = false;
            break;
        }
        if (bl) {
            this._audioResourcePlayer.playSimAudio("short-fanfare.wav");
            PhetOptionPane.showMessageDialog(this, NuclearPhysicsStrings.GUESSES_CORRECT_MESSAGE, NuclearPhysicsStrings.GUESSES_CORRECT_TITLE);
        }
    }

    private void clearGuessResults() {
        Iterator<AgeGuessResultNode> iterator = this._mapDatableItemsToGuessResults.values().iterator();
        while (iterator.hasNext()) {
            AgeGuessResultNode ageGuessResultNode = iterator.next();
            this._guessingGameLayer.removeChild(ageGuessResultNode);
            iterator.remove();
        }
    }

    private boolean determineIfGuessIsGood(double d, DatableItem datableItem) {
        double d2 = datableItem.getRadiometricAge();
        return d <= d2 * 1.2 && d >= d2 * 0.8;
    }

    private void configureProportionsChart() {
        double d = this._model.getMeter().getHalfLifeForDating();
        this._proportionsChart.setTimeParameters(d * 3.2, d);
        this._proportionsChart.setDisplayInfoForNucleusType(this._model.getMeter().getNucleusTypeUsedForDating());
        if (this._model.getMeter().getNucleusTypeUsedForDating() == NucleusType.CARBON_14) {
            this._proportionsChart.setShowCarbonOptions(true);
        } else {
            this._proportionsChart.setShowCarbonOptions(false);
        }
    }

    private Point2D findSpotForWindow(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getMaxX() + 8.0;
        double d2 = d + rectangle2D2.getWidth();
        double d3 = rectangle2D.getCenterY() - rectangle2D2.getHeight() / 2.0;
        double d4 = d3 + rectangle2D2.getHeight();
        if (d2 > this._transformedViewportBounds.getX() + this._transformedViewportBounds.getWidth() || d4 > this._transformedViewportBounds.getY() + this._transformedViewportBounds.getHeight()) {
            if (d2 > this._transformedViewportBounds.getX() + this._transformedViewportBounds.getWidth()) {
                d = this._transformedViewportBounds.getX() + this._transformedViewportBounds.getWidth() - rectangle2D2.getWidth() - 8.0;
                d3 = rectangle2D.getMaxY();
                d4 = d3 + rectangle2D2.getHeight();
            }
            if (d4 > this._transformedViewportBounds.getY() + this._transformedViewportBounds.getHeight()) {
                d3 = rectangle2D.getMaxX() + rectangle2D2.getWidth() < this._transformedViewportBounds.getX() + this._transformedViewportBounds.getWidth() ? this._transformedViewportBounds.getY() + this._transformedViewportBounds.getHeight() - rectangle2D2.getHeight() - 8.0 : rectangle2D.getY() - rectangle2D2.getHeight();
            }
        }
        return new Point2D.Double(d, d3);
    }
}

