/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PieChartNode;
import edu.colorado.phet.common.piccolophet.nodes.ResizeArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.MultiNucleusDecayModel;
import edu.colorado.phet.nuclearphysics.common.view.AtomicNucleusImageType;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.module.halflife.AutopressResetButton;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusImageNode;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusNode;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusSphereNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultiNucleusDecayLinearTimeChart
extends PNode {
    private static final Dimension2D NOMINAL_SIZE = new PDimension(800.0, 125.0);
    private static final Color BORDER_COLOR = Color.DARK_GRAY;
    private static final Stroke BORDER_STROKE = new BasicStroke(6.0f);
    private static final Stroke AXES_STROKE = new BasicStroke(0.5f);
    private static final Color AXES_LINE_COLOR = Color.BLACK;
    private static final Stroke TICK_MARK_STROKE = new BasicStroke(2.0f);
    private static final Font TICK_MARK_LABEL_FONT = new PhetFont(0, 12);
    private static final Color TICK_MARK_COLOR = AXES_LINE_COLOR;
    private static final Font SMALL_LABEL_FONT = new PhetFont(1, 14);
    private static final Font LARGE_LABEL_FONT = new PhetFont(1, 18);
    private static final Font ISOTOPE_LABEL_FONT = new PhetFont(0, 20);
    private static final Font ATOMIC_WEIGHT_LABEL_FONT = new PhetFont(1, 16);
    private static final Stroke HALF_LIFE_LINE_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static final Color HALF_LIFE_LINE_COLOR;
    private static final Color HALF_LIFE_TEXT_COLOR;
    private static final Font HALF_LIFE_FONT;
    private static final Point2D[] BUNCHING_OFFSETS;
    MultiNucleusDecayModel _model;
    AutopressResetButton _canvas;
    private double _timeSpan = 1000.0;
    private HashMap _mapNucleiToNucleiData = new HashMap();
    private int _preDecayCount;
    private int _postDecayCount;
    private int[] _decaysPerHistogramBucket = new int[60];
    private PPath _backgroundNode;
    private PPath _halfLifeMarkerLine;
    private ResizeArrowNode _halfLifeHandleNode;
    private PText _halfLifeLabel;
    private ArrowNode _xAxisOfGraph;
    private ArrayList<PhetPPath> _xAxisTickMarks = new ArrayList();
    private ArrayList<PText> _xAxisTickMarkLabels = new ArrayList();
    private PPath _yAxisUpperTickMark;
    private PPath _yAxisLowerTickMark;
    private ShadowHTMLNode _yAxisUpperTickMarkLabel;
    private ShadowHTMLNode _yAxisLowerTickMarkLabel;
    private PText _xAxisLabel;
    private HTMLNode _yAxisLabel;
    private ShadowHTMLNode _numUndecayedNucleiLabel;
    private PText _numUndecayedNucleiText;
    private ShadowHTMLNode _numDecayedNucleiLabel;
    private PText _numDecayedNucleiText;
    private PText _dummyNumberText;
    private PieChartNode _pieChart;
    private PieChartNode.PieValue[] _pieChartValues;
    private PComposite _nonPickableChartNode;
    private PNode _pickableChartNode;
    double _usableAreaOriginX;
    double _usableAreaOriginY;
    double _usableWidth;
    double _usableHeight;
    double _graphOriginX;
    double _graphOriginY;
    double _nucleusNodeRadius;
    double _msToPixelsFactor = 1.0;
    private ConstantDtClock _clock;
    private int _bunchingCounter = 0;
    private AtomicNucleusImageType _imageTypeForNuclei;
    private YAxisLabelMode _yAxisLabelMode;

    public MultiNucleusDecayLinearTimeChart(MultiNucleusDecayModel multiNucleusDecayModel, AutopressResetButton autopressResetButton, AtomicNucleusImageType atomicNucleusImageType, YAxisLabelMode yAxisLabelMode) {
        this._clock = multiNucleusDecayModel.getClock();
        this._model = multiNucleusDecayModel;
        this._canvas = autopressResetButton;
        this._imageTypeForNuclei = atomicNucleusImageType;
        this._yAxisLabelMode = yAxisLabelMode;
        this._clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MultiNucleusDecayLinearTimeChart.this.handleClockTicked(clockEvent);
            }
        });
        this._model.addListener(new NuclearDecayListenerAdapter(){

            public void modelElementAdded(Object object) {
                MultiNucleusDecayLinearTimeChart.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                MultiNucleusDecayLinearTimeChart.this.handleModelElementRemoved(object);
            }

            public void nucleusTypeChanged() {
                NucleusDisplayInfo nucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusType(MultiNucleusDecayLinearTimeChart.this._model.getNucleusType());
                NucleusDisplayInfo nucleusDisplayInfo2 = NucleusDisplayInfo.getDisplayInfoForNucleusType(AtomicNucleus.getPostDecayNuclei(MultiNucleusDecayLinearTimeChart.this._model.getNucleusType()).get(0));
                if (MultiNucleusDecayLinearTimeChart.this._imageTypeForNuclei == AtomicNucleusImageType.NUCLEONS_VISIBLE) {
                    MultiNucleusDecayLinearTimeChart.this._pieChartValues[0].setColor(nucleusDisplayInfo.getLabelColor());
                    MultiNucleusDecayLinearTimeChart.this._pieChartValues[1].setColor(nucleusDisplayInfo2.getLabelColor());
                } else {
                    MultiNucleusDecayLinearTimeChart.this._pieChartValues[0].setColor(nucleusDisplayInfo.getDisplayColor());
                    MultiNucleusDecayLinearTimeChart.this._pieChartValues[1].setColor(nucleusDisplayInfo2.getDisplayColor());
                }
                MultiNucleusDecayLinearTimeChart.this.doLayout();
            }

            public void halfLifeChanged() {
                MultiNucleusDecayLinearTimeChart.this.positionHalfLifeMarker();
            }
        });
        this._backgroundNode = new PPath();
        this._backgroundNode.setStroke(BORDER_STROKE);
        this._backgroundNode.setStrokePaint(BORDER_COLOR);
        this._backgroundNode.setPaint(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR);
        this.addChild(this._backgroundNode);
        this._nonPickableChartNode = new PComposite();
        this._nonPickableChartNode.setPickable(false);
        this._nonPickableChartNode.setChildrenPickable(false);
        this._backgroundNode.addChild(this._nonPickableChartNode);
        this._pickableChartNode = new PNode();
        this._pickableChartNode.setPickable(true);
        this._pickableChartNode.setChildrenPickable(true);
        this._backgroundNode.addChild(this._pickableChartNode);
        this._xAxisOfGraph = new ArrowNode(new Point2D.Double(10.0, 10.0), new Point2D.Double(20.0, 20.0), 9.0, 7.0, 1.0);
        this._xAxisOfGraph.setStroke(AXES_STROKE);
        this._xAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
        this._xAxisOfGraph.setPaint(AXES_LINE_COLOR);
        this._nonPickableChartNode.addChild(this._xAxisOfGraph);
        this._yAxisUpperTickMark = new PPath();
        this._yAxisUpperTickMark.setStroke(TICK_MARK_STROKE);
        this._yAxisUpperTickMark.setStrokePaint(TICK_MARK_COLOR);
        this._nonPickableChartNode.addChild(this._yAxisUpperTickMark);
        this._yAxisLowerTickMark = new PPath();
        this._yAxisLowerTickMark.setStroke(TICK_MARK_STROKE);
        this._yAxisLowerTickMark.setStrokePaint(TICK_MARK_COLOR);
        this._nonPickableChartNode.addChild(this._yAxisLowerTickMark);
        this._yAxisUpperTickMarkLabel = new ShadowHTMLNode();
        this._nonPickableChartNode.addChild(this._yAxisUpperTickMarkLabel);
        this._yAxisLowerTickMarkLabel = new ShadowHTMLNode();
        this._nonPickableChartNode.addChild(this._yAxisLowerTickMarkLabel);
        if (this._yAxisLabelMode == YAxisLabelMode.ISOTOPE_SYMBOL) {
            this._yAxisLabel = new HTMLNode(NuclearPhysicsStrings.DECAY_TIME_CHART_Y_AXIS_LABEL_ISOTOPE);
            this._yAxisUpperTickMarkLabel.setFont(ISOTOPE_LABEL_FONT);
            this._yAxisLowerTickMarkLabel.setFont(ISOTOPE_LABEL_FONT);
        } else {
            this._yAxisLabel = new HTMLNode(NuclearPhysicsStrings.DECAY_TIME_CHART_LABEL_ATOMIC_WEIGHT);
            this._yAxisUpperTickMarkLabel.setFont(ATOMIC_WEIGHT_LABEL_FONT);
            this._yAxisLowerTickMarkLabel.setFont(ATOMIC_WEIGHT_LABEL_FONT);
        }
        this._yAxisLabel.setFont(LARGE_LABEL_FONT);
        this._yAxisLabel.rotate(4.71238898038469);
        this._nonPickableChartNode.addChild(this._yAxisLabel);
        this._xAxisLabel = new PText(NuclearPhysicsStrings.DECAY_TIME_CHART_X_AXIS_LABEL + " (" + NuclearPhysicsStrings.DECAY_TIME_UNITS + ")");
        this._xAxisLabel.setFont(SMALL_LABEL_FONT);
        this._nonPickableChartNode.addChild(this._xAxisLabel);
        this._pieChartValues = new PieChartNode.PieValue[]{new PieChartNode.PieValue(this._model.getTotalNumNuclei(), NuclearPhysicsConstants.POLONIUM_LABEL_COLOR), new PieChartNode.PieValue(0.0, NuclearPhysicsConstants.LEAD_LABEL_COLOR)};
        this._pieChart = new PieChartNode(this._pieChartValues, new Rectangle(20, 20));
        this._nonPickableChartNode.addChild(this._pieChart);
        this._numUndecayedNucleiLabel = new ShadowHTMLNode();
        this._numUndecayedNucleiLabel.setFont(ISOTOPE_LABEL_FONT);
        this._nonPickableChartNode.addChild(this._numUndecayedNucleiLabel);
        this._numUndecayedNucleiText = new PText("0");
        this._numUndecayedNucleiText.setFont(ISOTOPE_LABEL_FONT);
        this._nonPickableChartNode.addChild(this._numUndecayedNucleiText);
        this._numDecayedNucleiLabel = new ShadowHTMLNode();
        this._numDecayedNucleiLabel.setFont(ISOTOPE_LABEL_FONT);
        this._nonPickableChartNode.addChild(this._numDecayedNucleiLabel);
        this._numDecayedNucleiText = new PText("0");
        this._numDecayedNucleiText.setFont(ISOTOPE_LABEL_FONT);
        this._nonPickableChartNode.addChild(this._numDecayedNucleiText);
        this._dummyNumberText = new PText("00");
        this._dummyNumberText.setFont(ISOTOPE_LABEL_FONT);
        this._halfLifeMarkerLine = new PPath();
        this._halfLifeMarkerLine.setStroke(HALF_LIFE_LINE_STROKE);
        this._halfLifeMarkerLine.setStrokePaint(HALF_LIFE_LINE_COLOR);
        this._halfLifeMarkerLine.setPaint(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR);
        this._nonPickableChartNode.addChild(this._halfLifeMarkerLine);
        this._halfLifeHandleNode = new ResizeArrowNode(45.0, 0.0, Color.GREEN, Color.YELLOW);
        this._pickableChartNode.addChild(this._halfLifeHandleNode);
        this._halfLifeHandleNode.addInputEventListener(new PBasicInputEventHandler(){
            boolean halfLifeChanged;

            public void mousePressed(PInputEvent pInputEvent) {
                this.halfLifeChanged = false;
                MultiNucleusDecayLinearTimeChart.this._model.getClock().setPaused(true);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                MultiNucleusDecayLinearTimeChart.this._model.getClock().setPaused(false);
                if (this.halfLifeChanged && MultiNucleusDecayLinearTimeChart.this._model.resetActiveAndDecayedNuclei() != 0) {
                    MultiNucleusDecayLinearTimeChart.this._canvas.autoPressResetNucleiButton();
                }
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                PNode pNode = pInputEvent.getPickedNode();
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
                pNode.localToParent(pDimension);
                double d = MultiNucleusDecayLinearTimeChart.this._model.getHalfLife() + pDimension.width / MultiNucleusDecayLinearTimeChart.this._msToPixelsFactor;
                if (d >= 10.0 && d <= MultiNucleusDecayLinearTimeChart.this._timeSpan * 0.95) {
                    MultiNucleusDecayLinearTimeChart.this._model.setHalfLife(d);
                    this.halfLifeChanged = true;
                }
            }
        });
        this._halfLifeLabel = new PText(NuclearPhysicsStrings.HALF_LIFE_LABEL);
        this._halfLifeLabel.setFont(HALF_LIFE_FONT);
        this._halfLifeLabel.setTextPaint(HALF_LIFE_TEXT_COLOR);
        this._nonPickableChartNode.addChild(this._halfLifeLabel);
    }

    public void setTimeSpan(double d) {
        this._timeSpan = d;
        this._msToPixelsFactor = (this._usableWidth - this._graphOriginX) * 0.98 / this._timeSpan;
        this.doLayout();
    }

    public void reset() {
        this.doLayout();
    }

    private void updateSize(Dimension2D dimension2D) {
        if (dimension2D.getWidth() == 0.0 || dimension2D.getHeight() == 0.0) {
            return;
        }
        this.setScale(1.0);
        this.setScale(Math.min(dimension2D.getWidth() / this._backgroundNode.getFullBoundsReference().width, dimension2D.getHeight() / this._backgroundNode.getFullBoundsReference().height));
    }

    private void doLayout() {
        this._usableAreaOriginX = 6.0;
        this._usableAreaOriginY = 6.0;
        this._usableWidth = NOMINAL_SIZE.getWidth() - 12.0;
        this._usableHeight = NOMINAL_SIZE.getHeight() - 12.0;
        this._graphOriginX = this._usableAreaOriginX + 0.3 * this._usableWidth;
        this._graphOriginY = this._usableAreaOriginY + 0.67 * this._usableHeight;
        this._msToPixelsFactor = (this._usableWidth - this._graphOriginX) * 0.98 / this._timeSpan;
        this._nucleusNodeRadius = this._usableHeight * 0.1 / 2.0;
        this._backgroundNode.setPathTo(new RoundRectangle2D.Double(this._usableAreaOriginX, this._usableAreaOriginY, NOMINAL_SIZE.getWidth(), NOMINAL_SIZE.getHeight(), 20.0, 20.0));
        this._xAxisOfGraph.setTipAndTailLocations(new Point2D.Double(this._graphOriginX + this._timeSpan * this._msToPixelsFactor + 10.0, this._graphOriginY), new Point2D.Double(this._graphOriginX, this._graphOriginY));
        this.updateXAxisTickMarksAndLabels();
        this.updateNucleusDependentLabels();
        double d = this._usableAreaOriginY + NOMINAL_SIZE.getHeight() * 0.2;
        double d2 = this._usableAreaOriginY + NOMINAL_SIZE.getHeight() * 0.5;
        this._yAxisLowerTickMark.setPathTo(new Line2D.Double(this._graphOriginX - 3.0, d2, this._graphOriginX, d2));
        this._yAxisLowerTickMarkLabel.setOffset(this._graphOriginX - this._yAxisLowerTickMarkLabel.getFullBoundsReference().getWidth() - this._yAxisLowerTickMark.getWidth() * 1.5, d2 - 0.5 * this._yAxisLowerTickMarkLabel.getFullBoundsReference().height);
        this._yAxisUpperTickMark.setPathTo(new Line2D.Double(this._graphOriginX - 3.0, d, this._graphOriginX, d));
        this._yAxisUpperTickMarkLabel.setOffset(this._graphOriginX - this._yAxisUpperTickMarkLabel.getFullBoundsReference().getWidth() - this._yAxisUpperTickMark.getWidth() * 1.5, d - 0.5 * this._yAxisUpperTickMarkLabel.getFullBoundsReference().height);
        this._xAxisLabel.setOffset(this._graphOriginX - this._xAxisLabel.getFullBoundsReference().width / 2.0, this._xAxisTickMarkLabels.get(0).getFullBoundsReference().getMaxY());
        this._yAxisLabel.setScale(1.0);
        double d3 = (this._graphOriginY - this._usableAreaOriginY) * 0.85;
        double d4 = d3 * 0.5;
        double d5 = Math.min(d3 / this._yAxisLabel.getFullBoundsReference().height, d4 / this._yAxisLabel.getFullBoundsReference().width);
        this._yAxisLabel.setScale(d5);
        double d6 = this._yAxisUpperTickMark.getY() + (this._yAxisLowerTickMark.getY() - this._yAxisUpperTickMark.getY()) / 2.0;
        double d7 = 4.0;
        double d8 = this._yAxisUpperTickMarkLabel.getFullBoundsReference().isEmpty() || this._yAxisLowerTickMarkLabel.getFullBoundsReference().isEmpty() ? Math.min(this._yAxisUpperTickMark.getFullBoundsReference().getMinX(), this._yAxisLowerTickMark.getFullBoundsReference().getMinX()) - d7 : Math.min(this._yAxisUpperTickMarkLabel.getFullBoundsReference().getMinX(), this._yAxisLowerTickMarkLabel.getFullBoundsReference().getMinX()) - d7;
        this._yAxisLabel.setOffset(d8 - this._yAxisLabel.getFullBoundsReference().width * 1.1, d6 + this._yAxisLabel.getFullBounds().height / 2.0);
        int n = (int)Math.round(Math.min(NOMINAL_SIZE.getWidth() * 0.1, NOMINAL_SIZE.getHeight() * 0.4));
        this._pieChart.setArea(new Rectangle(n, n));
        this._pieChart.setOffset(this._yAxisLabel.getFullBoundsReference().getX() - this._pieChart.getFullBoundsReference().getWidth(), d6 - this._pieChart.getFullBoundsReference().height / 2.0);
        PBounds pBounds = this._pieChart.getFullBoundsReference();
        double d9 = this._dummyNumberText.getFullBoundsReference().width;
        double d10 = this._dummyNumberText.getFullBoundsReference().height;
        this._dummyNumberText.setOffset(pBounds.getX() - d9 * 1.2, d - d10 / 2.0);
        this._numUndecayedNucleiLabel.setOffset(this._dummyNumberText.getFullBoundsReference().x - this._numUndecayedNucleiLabel.getFullBoundsReference().width * 1.1, d - this._numUndecayedNucleiLabel.getFullBoundsReference().height / 2.0 - 2.0);
        this._numDecayedNucleiLabel.setOffset(this._dummyNumberText.getFullBoundsReference().x - this._numDecayedNucleiLabel.getFullBoundsReference().width * 1.1, d2 - this._numDecayedNucleiText.getFullBoundsReference().height / 2.0 - 2.0);
        this.positionHalfLifeMarker();
        this.updateNucleiNumberText();
        this.updatePieChartProportions();
        Set set = this._mapNucleiToNucleiData.entrySet();
        for (Map.Entry entry : set) {
            AtomicNucleus atomicNucleus = (AtomicNucleus)entry.getKey();
            NucleusData nucleusData = (NucleusData)this._mapNucleiToNucleiData.get(atomicNucleus);
            if (nucleusData == null) continue;
            nucleusData.updateNucleusNodeScale();
            nucleusData.updateNucleusNodePosition();
        }
    }

    public void componentResized(Dimension2D dimension2D) {
        this.updateSize(dimension2D);
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        Set set = this._mapNucleiToNucleiData.entrySet();
        for (Map.Entry entry : set) {
            AtomicNucleus atomicNucleus = (AtomicNucleus)entry.getKey();
            NucleusData nucleusData = (NucleusData)this._mapNucleiToNucleiData.get(atomicNucleus);
            if (nucleusData == null) continue;
            nucleusData.updateNucleusDataState();
        }
    }

    private void updateNucleusDependentLabels() {
        NucleusDisplayInfo nucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusType(this._model.getNucleusType());
        NucleusDisplayInfo nucleusDisplayInfo2 = NucleusDisplayInfo.getDisplayInfoForNucleusType(AtomicNucleus.getPostDecayNuclei(this._model.getNucleusType()).get(0));
        this._numUndecayedNucleiLabel.setHtml("<html># <sup><font size=-1>" + nucleusDisplayInfo.getIsotopeNumberString() + "</font></sup>" + nucleusDisplayInfo.getChemicalSymbol());
        this._numDecayedNucleiLabel.setHtml("<html># <sup><font size=-1>" + nucleusDisplayInfo2.getIsotopeNumberString() + "</font></sup>" + nucleusDisplayInfo2.getChemicalSymbol());
        if (this._imageTypeForNuclei == AtomicNucleusImageType.NUCLEONS_VISIBLE) {
            this._numUndecayedNucleiLabel.setColor(nucleusDisplayInfo.getLabelColor());
            this._numDecayedNucleiLabel.setColor(nucleusDisplayInfo2.getLabelColor());
        } else {
            this._numUndecayedNucleiLabel.setColor(nucleusDisplayInfo.getDisplayColor());
            this._numDecayedNucleiLabel.setColor(nucleusDisplayInfo2.getDisplayColor());
        }
        if (this._yAxisLabelMode == YAxisLabelMode.ISOTOPE_SYMBOL) {
            this._yAxisUpperTickMarkLabel.setHtml("<html><sup><font size=-1>" + nucleusDisplayInfo.getIsotopeNumberString() + "</font></sup>" + nucleusDisplayInfo.getChemicalSymbol());
            this._yAxisLowerTickMarkLabel.setHtml("<html><sup><font size=-1>" + nucleusDisplayInfo2.getIsotopeNumberString() + "</font></sup>" + nucleusDisplayInfo2.getChemicalSymbol());
            if (this._imageTypeForNuclei == AtomicNucleusImageType.NUCLEONS_VISIBLE) {
                this._yAxisUpperTickMarkLabel.setColor(nucleusDisplayInfo.getLabelColor());
                this._yAxisLowerTickMarkLabel.setColor(nucleusDisplayInfo2.getLabelColor());
            } else {
                this._yAxisUpperTickMarkLabel.setColor(nucleusDisplayInfo.getDisplayColor());
                this._yAxisLowerTickMarkLabel.setColor(nucleusDisplayInfo2.getDisplayColor());
            }
        } else {
            this._yAxisUpperTickMarkLabel.setColor(Color.BLACK);
            this._yAxisUpperTickMarkLabel.setShadowColor(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR);
            this._yAxisUpperTickMarkLabel.setHtml("<html>" + nucleusDisplayInfo.getIsotopeNumberString() + "</html>");
            this._yAxisLowerTickMarkLabel.setColor(Color.BLACK);
            this._yAxisLowerTickMarkLabel.setShadowColor(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR);
            this._yAxisLowerTickMarkLabel.setHtml("<html>" + nucleusDisplayInfo2.getIsotopeNumberString() + "</html>");
        }
    }

    private void updateNucleiNumberText() {
        this._numUndecayedNucleiText.setText(Integer.toString(this._preDecayCount));
        this._numDecayedNucleiText.setText(Integer.toString(this._postDecayCount));
        double d = this._yAxisUpperTickMark.getFullBoundsReference().getCenterY();
        double d2 = this._yAxisLowerTickMark.getFullBoundsReference().getCenterY();
        double d3 = this._dummyNumberText.getFullBoundsReference().height;
        double d4 = this._dummyNumberText.getFullBoundsReference().getMaxX();
        this._numUndecayedNucleiText.setOffset(d4 - this._numUndecayedNucleiText.getFullBoundsReference().width, d - d3 / 2.0);
        this._numDecayedNucleiText.setOffset(d4 - this._numDecayedNucleiText.getFullBoundsReference().width, d2 - d3 / 2.0);
    }

    private void updatePieChartProportions() {
        if (this._preDecayCount == 0 && this._postDecayCount == 0) {
            this._pieChartValues[0].setValue(1.0);
            this._pieChartValues[1].setValue(0.0);
        } else {
            this._pieChartValues[0].setValue(this._preDecayCount);
            this._pieChartValues[1].setValue(this._postDecayCount);
        }
        this._pieChart.setPieValues(this._pieChartValues);
    }

    private void handleModelElementAdded(Object object) {
        if (object instanceof AtomicNucleus) {
            assert (!this._mapNucleiToNucleiData.containsKey(object));
            this._mapNucleiToNucleiData.put(object, new NucleusData((AtomicNucleus)object));
        }
    }

    private void handleModelElementRemoved(Object object) {
        if (object instanceof AtomicNucleus) {
            NucleusData nucleusData = (NucleusData)this._mapNucleiToNucleiData.get(object);
            if (nucleusData != null) {
                nucleusData.removeNodeFromChart();
                this._mapNucleiToNucleiData.remove(object);
            } else {
                System.err.println("Error: Unable to locate nucleus data in map.");
            }
        }
    }

    private void positionHalfLifeMarker() {
        double d = this._model.getHalfLife();
        this._halfLifeMarkerLine.reset();
        this._halfLifeMarkerLine.moveTo((float)(this._graphOriginX + (0.05 * this._timeSpan + d) * this._msToPixelsFactor), (float)(this._graphOriginY + (this._usableHeight - this._graphOriginY) * 0.4));
        this._halfLifeMarkerLine.lineTo((float)(this._graphOriginX + (0.05 * this._timeSpan + d) * this._msToPixelsFactor), (float)(this._usableAreaOriginY + 0.1 * this._usableHeight));
        for (int i = 0; i < this._xAxisTickMarkLabels.size(); ++i) {
            PNode pNode = this._xAxisTickMarkLabels.get(i);
            if (!pNode.getFullBoundsReference().intersects(this._halfLifeMarkerLine.getFullBoundsReference())) continue;
            this._halfLifeMarkerLine.reset();
            this._halfLifeMarkerLine.moveTo((float)(this._graphOriginX + (0.05 * this._timeSpan + d) * this._msToPixelsFactor), (float)this._graphOriginY);
            this._halfLifeMarkerLine.lineTo((float)(this._graphOriginX + (0.05 * this._timeSpan + d) * this._msToPixelsFactor), (float)(this._usableAreaOriginY + 0.1 * this._usableHeight));
            break;
        }
        this._halfLifeHandleNode.setOffset(this._halfLifeMarkerLine.getX(), this._halfLifeMarkerLine.getY() + (this._graphOriginY - this._halfLifeMarkerLine.getY()) / 2.0);
        if (this._model.getNucleusType() == NucleusType.HEAVY_CUSTOM || this._model.getNucleusType() == NucleusType.LIGHT_CUSTOM) {
            if (!this._halfLifeHandleNode.isVisible()) {
                this._halfLifeHandleNode.setVisible(true);
                this._halfLifeHandleNode.flash();
            }
        } else {
            this._halfLifeHandleNode.setVisible(false);
        }
        this._halfLifeLabel.setOffset(this._halfLifeMarkerLine.getX() - this._halfLifeLabel.getFullBoundsReference().width / 2.0, (float)(this._graphOriginY + (this._usableHeight - this._graphOriginY) * 0.5));
        if (this._xAxisLabel.getFullBoundsReference().intersects(this._halfLifeLabel.getFullBoundsReference())) {
            this._xAxisLabel.setVisible(false);
        } else {
            this._xAxisLabel.setVisible(true);
        }
    }

    private void updateXAxisTickMarksAndLabels() {
        int n;
        for (PhetPPath pNode : this._xAxisTickMarks) {
            this._nonPickableChartNode.removeChild(pNode);
        }
        for (PText pText : this._xAxisTickMarkLabels) {
            this._nonPickableChartNode.removeChild(pText);
        }
        this._xAxisTickMarks.clear();
        this._xAxisTickMarkLabels.clear();
        double d = this._timeSpan * 0.95;
        if (this._timeSpan < 10000.0) {
            int n2 = (int)(d / 1000.0 + 1.0);
            for (n = 0; n < n2; ++n) {
                String string = n == 0 ? "0.0" : Integer.toString(n);
                this.addXAxisTickMark(n * 1000, string);
            }
        } else if (this._timeSpan < HalfLifeInfo.convertYearsToMs(100.0)) {
            int n3 = (int)(d / HalfLifeInfo.convertYearsToMs(10.0) + 1.0);
            for (n = 0; n < n3; ++n) {
                String string = n == 0 ? "0.0" : Integer.toString(n * 10);
                this.addXAxisTickMark((double)n * HalfLifeInfo.convertYearsToMs(10.0), string);
            }
        } else if (this._timeSpan < HalfLifeInfo.convertYearsToMs(1.0E9)) {
            int n4 = (int)(d / HalfLifeInfo.convertYearsToMs(5000.0) + 1.0);
            for (n = 0; n < n4; ++n) {
                String string = n == 0 ? "0.0" : Integer.toString(n * 5000);
                this.addXAxisTickMark((double)n * HalfLifeInfo.convertYearsToMs(5000.0), string);
            }
        } else {
            int n5 = (int)(d / HalfLifeInfo.convertYearsToMs(4.0E9) + 1.0);
            for (n = 0; n < n5; ++n) {
                this.addXAxisTickMark((double)n * HalfLifeInfo.convertYearsToMs(4.0E9), String.format("%.1f", Float.valueOf(n * 4)));
            }
        }
        double d2 = this._graphOriginY + 5.0;
        if (this._xAxisTickMarkLabels.size() > 0) {
            d2 = this._xAxisTickMarkLabels.get(0).getFullBoundsReference().getMaxY();
        }
        this._xAxisLabel.setText(NuclearPhysicsStrings.DECAY_TIME_CHART_X_AXIS_LABEL + " (" + this.getXAxisUnitsText() + ")");
        this._xAxisLabel.setOffset(this._graphOriginX - this._xAxisLabel.getFullBoundsReference().width / 2.0, d2);
    }

    private void addXAxisTickMark(double d, String string) {
        double d2 = this._graphOriginX + 0.05 * this._timeSpan * this._msToPixelsFactor;
        PhetPPath phetPPath = new PhetPPath(TICK_MARK_COLOR);
        phetPPath.setPathTo(new Line2D.Double(0.0, 0.0, 0.0, -3.0));
        phetPPath.setStroke(TICK_MARK_STROKE);
        phetPPath.setOffset(d2 + d * this._msToPixelsFactor, this._graphOriginY);
        this._nonPickableChartNode.addChild(phetPPath);
        this._xAxisTickMarks.add(phetPPath);
        PText pText = new PText();
        pText.setText(string);
        pText.setFont(TICK_MARK_LABEL_FONT);
        pText.setOffset(phetPPath.getOffset().getX() - pText.getFullBoundsReference().width / 2.0, this._graphOriginY + pText.getFullBoundsReference().height * 0.1);
        this._nonPickableChartNode.addChild(pText);
        this._xAxisTickMarkLabels.add(pText);
    }

    private String getXAxisUnitsText() {
        String string = this._timeSpan > HalfLifeInfo.convertYearsToMs(100000.0) ? NuclearPhysicsStrings.TIME_GRAPH_UNITS_BILLION_YRS : (this._timeSpan > 10000.0 ? NuclearPhysicsStrings.TIME_GRAPH_UNITS_YRS : NuclearPhysicsStrings.TIME_GRAPH_UNITS_SECONDS);
        return string;
    }

    private int mapDecayTimeToHistogramBucket(double d) {
        if (d > this._timeSpan) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.floor(d / (this._timeSpan / 60.0));
    }

    private double calculateFallTarget(int n) {
        double d = this._usableHeight * 0.3;
        double d2 = this._nucleusNodeRadius * 2.0 * ((double)n * 0.2);
        return Math.max((d - d2) / d, 0.0);
    }

    static {
        HALF_LIFE_TEXT_COLOR = HALF_LIFE_LINE_COLOR = new Color(238, 0, 0);
        HALF_LIFE_FONT = new PhetFont(1, 16);
        BUNCHING_OFFSETS = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(-0.02, -0.025), new Point2D.Double(0.025, -0.02), new Point2D.Double(0.015, 0.025), new Point2D.Double(-0.015, 0.015)};
    }

    private class NucleusData {
        private AtomicNucleus _nucleus;
        private LabeledNucleusNode _nucleusNode;
        private int _fallCount;
        private double _fallTarget;
        private int _internalState;
        private int _decayBucket;
        private Point2D _bunchingOffset;

        public NucleusData(AtomicNucleus atomicNucleus) {
            this._nucleus = atomicNucleus;
            this._fallCount = 0;
            this._fallTarget = 0.0;
            this._internalState = 1;
            this._decayBucket = Integer.MAX_VALUE;
            this._bunchingOffset = BUNCHING_OFFSETS[0];
        }

        public void updateNucleusDataState() {
            switch (this._internalState) {
                case 1: {
                    if (!this._nucleus.isDecayActive()) break;
                    this._internalState = 2;
                    MultiNucleusDecayLinearTimeChart.this._preDecayCount++;
                    MultiNucleusDecayLinearTimeChart.this.updateNucleiNumberText();
                    MultiNucleusDecayLinearTimeChart.this.updatePieChartProportions();
                    if (this._nucleusNode == null) {
                        this._nucleusNode = this.createNucleusNode();
                        this._nucleusNode.setScale(MultiNucleusDecayLinearTimeChart.this._nucleusNodeRadius * 2.0 / this._nucleusNode.getFullBoundsReference().height);
                    }
                    MultiNucleusDecayLinearTimeChart.this._nonPickableChartNode.addChild(this._nucleusNode);
                    this._fallCount = 5;
                    this._bunchingOffset = BUNCHING_OFFSETS[MultiNucleusDecayLinearTimeChart.this._bunchingCounter];
                    MultiNucleusDecayLinearTimeChart.this._bunchingCounter = (MultiNucleusDecayLinearTimeChart.this._bunchingCounter + 1) % BUNCHING_OFFSETS.length;
                    this.updateNucleusNodePosition();
                    break;
                }
                case 2: {
                    if (this._nucleus.hasDecayed()) {
                        this._internalState = 3;
                        MultiNucleusDecayLinearTimeChart.this._preDecayCount--;
                        MultiNucleusDecayLinearTimeChart.this._postDecayCount++;
                        MultiNucleusDecayLinearTimeChart.this.updateNucleiNumberText();
                        MultiNucleusDecayLinearTimeChart.this.updatePieChartProportions();
                        this.updateNucleusImageNode();
                        this._decayBucket = MultiNucleusDecayLinearTimeChart.this.mapDecayTimeToHistogramBucket(this._nucleus.getAdjustedActivatedTime());
                        if (this._decayBucket < MultiNucleusDecayLinearTimeChart.this._decaysPerHistogramBucket.length) {
                            this._fallTarget = MultiNucleusDecayLinearTimeChart.this.calculateFallTarget(MultiNucleusDecayLinearTimeChart.this._decaysPerHistogramBucket[this._decayBucket]);
                            int[] nArray = MultiNucleusDecayLinearTimeChart.this._decaysPerHistogramBucket;
                            int n = this._decayBucket;
                            nArray[n] = nArray[n] + 1;
                        } else {
                            this._fallTarget = MultiNucleusDecayLinearTimeChart.this.calculateFallTarget(0);
                        }
                        --this._fallCount;
                    } else if (!this._nucleus.isDecayActive()) {
                        this._internalState = 1;
                        MultiNucleusDecayLinearTimeChart.this._preDecayCount--;
                        MultiNucleusDecayLinearTimeChart.this.updateNucleiNumberText();
                        MultiNucleusDecayLinearTimeChart.this.updatePieChartProportions();
                        this.removeNodeFromChart();
                    }
                    this.updateNucleusNodePosition();
                    break;
                }
                case 3: {
                    if (this._nucleus.isDecayActive() && !this._nucleus.hasDecayed()) {
                        this._internalState = 2;
                        this.updateNucleusImageNode();
                        this._fallCount = 5;
                        if (this._decayBucket < 60) {
                            int[] nArray = MultiNucleusDecayLinearTimeChart.this._decaysPerHistogramBucket;
                            int n = this._decayBucket;
                            nArray[n] = nArray[n] - 1;
                        }
                        this._decayBucket = Integer.MAX_VALUE;
                        MultiNucleusDecayLinearTimeChart.this._postDecayCount--;
                        MultiNucleusDecayLinearTimeChart.this._preDecayCount++;
                        MultiNucleusDecayLinearTimeChart.this.updateNucleiNumberText();
                        MultiNucleusDecayLinearTimeChart.this.updatePieChartProportions();
                        break;
                    }
                    if (!this._nucleus.isDecayActive() && !this._nucleus.hasDecayed()) {
                        this._internalState = 1;
                        MultiNucleusDecayLinearTimeChart.this._postDecayCount--;
                        MultiNucleusDecayLinearTimeChart.this.updateNucleiNumberText();
                        MultiNucleusDecayLinearTimeChart.this.updatePieChartProportions();
                        this.removeNodeFromChart();
                        break;
                    }
                    if (this._fallCount <= 0) break;
                    --this._fallCount;
                    this.updateNucleusNodePosition();
                    break;
                }
                default: {
                    System.err.println("Unexpected nucleus data state.");
                    assert (false);
                    break;
                }
            }
        }

        private void updateNucleusImageNode() {
            MultiNucleusDecayLinearTimeChart.this._nonPickableChartNode.removeChild(this._nucleusNode);
            this._nucleusNode = this.createNucleusNode();
            this._nucleusNode.setScale(MultiNucleusDecayLinearTimeChart.this._nucleusNodeRadius * 2.0 / this._nucleusNode.getFullBoundsReference().height);
            MultiNucleusDecayLinearTimeChart.this._nonPickableChartNode.addChild(this._nucleusNode);
        }

        public void removeNodeFromChart() {
            if (this._nucleusNode != null && MultiNucleusDecayLinearTimeChart.this._nonPickableChartNode.isAncestorOf(this._nucleusNode)) {
                MultiNucleusDecayLinearTimeChart.this._nonPickableChartNode.removeChild(this._nucleusNode);
                if (this._internalState == 2) {
                    MultiNucleusDecayLinearTimeChart.this._preDecayCount--;
                } else if (this._internalState == 3) {
                    MultiNucleusDecayLinearTimeChart.this._postDecayCount--;
                }
            }
            if (this._decayBucket != Integer.MAX_VALUE) {
                int[] nArray = MultiNucleusDecayLinearTimeChart.this._decaysPerHistogramBucket;
                int n = this._decayBucket;
                nArray[n] = nArray[n] - 1;
            }
        }

        public void updateNucleusNodeScale() {
            if (this._nucleusNode == null) {
                return;
            }
            this._nucleusNode.setScale(1.0);
            this._nucleusNode.setScale(MultiNucleusDecayLinearTimeChart.this._nucleusNodeRadius * 2.0 / this._nucleusNode.getFullBoundsReference().height);
        }

        public void updateNucleusNodePosition() {
            double d;
            double d2;
            if (this._nucleusNode == null) {
                return;
            }
            if (!this._nucleus.hasDecayed()) {
                d2 = MultiNucleusDecayLinearTimeChart.this._usableAreaOriginY + MultiNucleusDecayLinearTimeChart.this._usableHeight * 0.2 - MultiNucleusDecayLinearTimeChart.this._nucleusNodeRadius + this._bunchingOffset.getY() * MultiNucleusDecayLinearTimeChart.this._usableHeight;
            } else if (this._fallCount != 0) {
                d = MultiNucleusDecayLinearTimeChart.this._usableHeight * 0.3 * this._fallTarget;
                d2 = MultiNucleusDecayLinearTimeChart.this._usableAreaOriginY + MultiNucleusDecayLinearTimeChart.this._usableHeight * 0.2 + d * (1.0 - (double)this._fallCount / 5.0) - MultiNucleusDecayLinearTimeChart.this._nucleusNodeRadius;
            } else {
                d2 = MultiNucleusDecayLinearTimeChart.this._usableAreaOriginY + MultiNucleusDecayLinearTimeChart.this._usableHeight * 0.2 + MultiNucleusDecayLinearTimeChart.this._usableHeight * 0.3 * this._fallTarget - MultiNucleusDecayLinearTimeChart.this._nucleusNodeRadius;
            }
            double d3 = MultiNucleusDecayLinearTimeChart.this._graphOriginX + (this._nucleus.getAdjustedActivatedTime() + 0.05 * MultiNucleusDecayLinearTimeChart.this._timeSpan) * MultiNucleusDecayLinearTimeChart.this._msToPixelsFactor - MultiNucleusDecayLinearTimeChart.this._nucleusNodeRadius + this._bunchingOffset.getX() * MultiNucleusDecayLinearTimeChart.this._usableHeight;
            d = MultiNucleusDecayLinearTimeChart.this._usableAreaOriginX + MultiNucleusDecayLinearTimeChart.this._usableWidth;
            if (d3 >= d) {
                this._nucleusNode.setVisible(false);
                d3 = d;
            } else if (!this._nucleusNode.getVisible()) {
                this._nucleusNode.setVisible(true);
            }
            this._nucleusNode.setOffset(d3, d2);
        }

        private LabeledNucleusNode createNucleusNode() {
            NucleusDisplayInfo nucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusConfig(this._nucleus.getNumProtons(), this._nucleus.getNumNeutrons());
            if (MultiNucleusDecayLinearTimeChart.this._imageTypeForNuclei == AtomicNucleusImageType.NUCLEONS_VISIBLE) {
                return new LabeledNucleusImageNode(nucleusDisplayInfo);
            }
            return new LabeledNucleusSphereNode(nucleusDisplayInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class YAxisLabelMode
    extends Enum<YAxisLabelMode> {
        public static final /* enum */ YAxisLabelMode ATOMIC_WEIGHT = new YAxisLabelMode();
        public static final /* enum */ YAxisLabelMode ISOTOPE_SYMBOL = new YAxisLabelMode();
        private static final /* synthetic */ YAxisLabelMode[] $VALUES;

        public static YAxisLabelMode[] values() {
            return (YAxisLabelMode[])$VALUES.clone();
        }

        static {
            $VALUES = new YAxisLabelMode[]{ATOMIC_WEIGHT, ISOTOPE_SYMBOL};
        }
    }
}

