/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.view.SubatomicParticleNode;
import java.awt.Paint;

public class NucleonNode
extends SubatomicParticleNode {
    private SphericalNode _representation;
    private Nucleon _nucleon = null;
    private Nucleon.NucleonAdapter _nucleonListener;

    public NucleonNode() {
        this.updateRepresentation();
    }

    public NucleonNode(Nucleon nucleon) {
        super(nucleon);
        this._nucleon = nucleon;
        this._nucleonListener = new Nucleon.NucleonAdapter(){

            public void nucleonTypeChanged() {
                NucleonNode.this.updateRepresentation();
            }
        };
        this._nucleon.addListener(this._nucleonListener);
        this.updateRepresentation();
    }

    public void cleanup() {
        super.cleanup();
        this._nucleon.removeListener(this._nucleonListener);
    }

    private void updateRepresentation() {
        if (this._representation != null) {
            this.removeChild(this._representation);
        }
        Paint paint = this._nucleon.getNucleonType() == Nucleon.NucleonType.PROTON ? NuclearPhysicsConstants.PROTON_ROUND_GRADIENT : NuclearPhysicsConstants.NEUTRON_ROUND_GRADIENT;
        this._representation = new SphericalNode(1.6, paint, false);
        this.addChild(this._representation);
    }
}

