/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.nuclearphysics.view.AlphaParticleNode;
import edu.colorado.phet.nuclearphysics.view.StandaloneNeutronNode;
import edu.colorado.phet.nuclearphysics.view.StandaloneProtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class NucleusImageFactory {
    private static NucleusImageFactory _instance = null;
    private static Random _rand = new Random();
    private HashMap<Integer, HashMap<Integer, ImageList>> mapNumProtonsToNeutronMap = new HashMap();

    public static NucleusImageFactory getInstance() {
        if (_instance == null) {
            _instance = new NucleusImageFactory();
        }
        return _instance;
    }

    public PImage getNucleusImage(int n, int n2, double d) {
        Image image = this.getCachedImage(n, n2);
        if (image != null) {
            return new PImage(image);
        }
        return this.generateNucleusImage(n, n2, d);
    }

    public void preGenerateNucleusImages(int n, int n2, double d) {
        int n3 = this.getNumCachedImages(n, n2);
        if (n3 < 4) {
            for (int i = 0; i < 4 - n3; ++i) {
                this.generateNucleusImage(n, n2, d);
            }
        }
    }

    private PImage generateNucleusImage(int n, int n2, double d) {
        PNode pNode = new PNode();
        double d2 = this.getDiameter(n + n2) / 2.0;
        if (n + n2 == 3) {
            int n3 = n;
            int n4 = n2;
            double d3 = Math.PI;
            double d4 = 0.8 / Math.cos(0.5235987755982988);
            for (int i = 0; i < 3; ++i) {
                SphericalNode sphericalNode = null;
                if (n4 > 0) {
                    sphericalNode = new StandaloneNeutronNode();
                    --n4;
                } else {
                    sphericalNode = new StandaloneProtonNode();
                    --n3;
                }
                sphericalNode.scale(d);
                double d5 = 2.0943951023931953 * (double)i + d3;
                double d6 = Math.sin(d5) * d4 * d;
                double d7 = Math.cos(d5) * d4 * d;
                ((PNode)sphericalNode).setOffset(d6, d7);
                pNode.addChild(sphericalNode);
            }
        } else {
            int n5 = (n + n2) / 2 / 4;
            int n6 = n - n5 * 2;
            int n7 = n2 - n5 * 2;
            if (n6 > n7) {
                n7 = n6;
            }
            int n8 = Math.max(n5, n6);
            n8 = Math.max(n7, n8);
            for (int i = 0; i < n8; ++i) {
                if (n5 == n7) {
                    this.addAlpha(pNode, d2, d);
                    --n5;
                }
                if (n6 == n7) {
                    this.addProton(pNode, d2, d);
                    --n6;
                }
                this.addNeutron(pNode, d2, d);
                --n7;
            }
        }
        Image image = pNode.toImage();
        this.addCachedImage(n, n2, image);
        return new PImage(pNode.toImage());
    }

    private void addAlpha(PNode pNode, double d, double d2) {
        AlphaParticleNode alphaParticleNode = new AlphaParticleNode();
        alphaParticleNode.scale(d2);
        PImage pImage = new PImage(alphaParticleNode.toImage());
        this.setParticlePosition(d, pImage, d2);
        pNode.addChild(pImage);
    }

    private void addNeutron(PNode pNode, double d, double d2) {
        StandaloneNeutronNode standaloneNeutronNode = new StandaloneNeutronNode();
        standaloneNeutronNode.scale(d2);
        PImage pImage = new PImage(standaloneNeutronNode.toImage());
        this.setParticlePosition(d, pImage, d2);
        pNode.addChild(pImage);
    }

    private void addProton(PNode pNode, double d, double d2) {
        StandaloneProtonNode standaloneProtonNode = new StandaloneProtonNode();
        standaloneProtonNode.scale(d2);
        PImage pImage = new PImage(standaloneProtonNode.toImage());
        this.setParticlePosition(d, pImage, d2);
        pNode.addChild(pImage);
    }

    private void setParticlePosition(double d, PNode pNode, double d2) {
        double d3 = _rand.nextDouble() * Math.PI * 2.0;
        double d4 = _rand.nextDouble();
        if (d4 > 0.8) {
            d4 = d4 * _rand.nextDouble() / 2.0;
        }
        double d5 = d * d4 * d2;
        double d6 = Math.sin(d3) * d5;
        double d7 = Math.cos(d3) * d5;
        pNode.setOffset(d6, d7);
    }

    private double getDiameter(int n) {
        return 1.6 * Math.pow(n, 0.362);
    }

    private Image getCachedImage(int n, int n2) {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        HashMap<Integer, ImageList> hashMap = this.mapNumProtonsToNeutronMap.get(n3);
        if (hashMap == null) {
            return null;
        }
        ImageList imageList = hashMap.get(n4);
        if (imageList == null || !imageList.isFullyPopulated()) {
            return null;
        }
        return imageList.getRandomImage();
    }

    private int getNumCachedImages(int n, int n2) {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        HashMap<Integer, ImageList> hashMap = this.mapNumProtonsToNeutronMap.get(n3);
        if (hashMap == null) {
            return 0;
        }
        ImageList imageList = hashMap.get(n4);
        if (imageList == null) {
            return 0;
        }
        return imageList.getNumImages();
    }

    private void addCachedImage(int n, int n2, Image image) {
        ImageList imageList;
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        HashMap<Integer, ImageList> hashMap = this.mapNumProtonsToNeutronMap.get(n3);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.mapNumProtonsToNeutronMap.put(n3, hashMap);
        }
        if ((imageList = hashMap.get(n4)) == null) {
            imageList = new ImageList();
            hashMap.put(n4, imageList);
        }
        imageList.addImage(image);
    }

    private static class ImageList {
        ArrayList<Image> imageList = new ArrayList();

        private ImageList() {
        }

        public void addImage(Image image) {
            if (this.imageList.size() < 4) {
                this.imageList.add(image);
            } else {
                System.err.println(this.getClass().getName() + " - Warning: Attempt to add image to full list.");
            }
        }

        public Image getRandomImage() {
            return this.imageList.get(_rand.nextInt(this.imageList.size()));
        }

        public boolean isFullyPopulated() {
            return this.imageList.size() == 4;
        }

        public int getNumImages() {
            return this.imageList.size();
        }
    }
}

