/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.ConstantPowerOfTenNumberFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.model.AlphaDecayCompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.module.alphadecay.singlenucleus.SingleNucleusAlphaDecayModel;
import edu.colorado.phet.nuclearphysics.util.PhetButtonNode;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusImageNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.security.InvalidParameterException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class SingleNucleusAlphaDecayTimeChart
extends PNode {
    private static final Rectangle2D NOMINAL_SIZE = new Rectangle2D.Double(0.0, 0.0, 800.0, 120.0);
    private static final Color BORDER_COLOR = Color.DARK_GRAY;
    private static final Stroke BORDER_STROKE = new BasicStroke(6.0f);
    private static final Stroke AXES_STROKE = new BasicStroke(0.5f);
    private static final Color AXES_LINE_COLOR = Color.BLACK;
    private static final Stroke TICK_MARK_STROKE = new BasicStroke(2.0f);
    private static final Font TICK_MARK_LABEL_FONT = new PhetFont(0, 12);
    private static final Color TICK_MARK_COLOR = AXES_LINE_COLOR;
    private static final Font SMALL_LABEL_FONT = new PhetFont(0, 14);
    private static final Stroke HALF_LIFE_LINE_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static final Color HALF_LIFE_LINE_COLOR;
    private static final Color HALF_LIFE_TEXT_COLOR;
    private static final Font HALF_LIFE_FONT;
    private static final Color TIME_LINE_BASE_COLOR;
    SingleNucleusAlphaDecayModel _model;
    AlphaDecayCompositeNucleus _currentNucleus;
    EnhancedLabeledNucleusNode _undecayedNucleusNode;
    ArrayList<PNode> _decayedNucleusNodes = new ArrayList();
    private PPath _borderNode;
    private PPath _halfLifeMarkerLine;
    private PText _halfLifeLabel;
    private PText _halfLifeInfinityText;
    private ArrowNode _xAxisOfGraph;
    private ArrayList<PPath> _xAxisTickMarks;
    private ArrayList<PText> _xAxisTickMarkLabels;
    private ArrayList<PPath> _yAxisTickMarks;
    private ArrayList<PText> _yAxisTickMarkLabels;
    private PText _xAxisLabel;
    private HTMLNode _yAxisLabel;
    private TimeDisplayNode _timeDisplay;
    private PText _decayTimeLabel;
    private LogarithmicTimeLineNode _exponentialTimeLine;
    private PComposite _nonPickableChartNode;
    private PNode _pickableChartNode;
    double _usableAreaOriginX;
    double _usableAreaOriginY;
    double _usableWidth;
    double _usableHeight;
    double _graphOriginX;
    double _graphOriginY;
    double _nucleusNodeRadius;
    double _msToPixelsFactor = 1.0;
    ConstantDtClock _clock;
    PhetButtonNode _resetButtonNode;
    boolean _chartCleared = false;
    boolean _exponentialMode = false;

    public SingleNucleusAlphaDecayTimeChart(SingleNucleusAlphaDecayModel singleNucleusAlphaDecayModel) {
        PText pText;
        PPath pPath;
        this._clock = singleNucleusAlphaDecayModel.getClock();
        this._model = singleNucleusAlphaDecayModel;
        this._exponentialMode = this._model.getNucleusType() == NucleusType.HEAVY_CUSTOM;
        this._clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                SingleNucleusAlphaDecayTimeChart.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                SingleNucleusAlphaDecayTimeChart.this.reset();
            }
        });
        this._model.addListener(new NuclearDecayListenerAdapter(){

            public void modelElementAdded(Object object) {
                SingleNucleusAlphaDecayTimeChart.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                SingleNucleusAlphaDecayTimeChart.this.handleModelElementRemoved(object);
            }

            public void nucleusTypeChanged() {
                SingleNucleusAlphaDecayTimeChart.this.handleNucleusTypeChanged();
            }

            public void halfLifeChanged() {
                SingleNucleusAlphaDecayTimeChart.this.clearDecayedNuclei();
                SingleNucleusAlphaDecayTimeChart.this.positionHalfLifeMarker();
            }
        });
        this._nonPickableChartNode = new PComposite();
        this._nonPickableChartNode.setPickable(false);
        this._nonPickableChartNode.setChildrenPickable(false);
        this.addChild(this._nonPickableChartNode);
        this._pickableChartNode = new PNode();
        this._pickableChartNode.setPickable(true);
        this._pickableChartNode.setChildrenPickable(true);
        this.addChild(this._pickableChartNode);
        this._borderNode = new PPath();
        this._borderNode.setStroke(BORDER_STROKE);
        this._borderNode.setStrokePaint(BORDER_COLOR);
        this._borderNode.setPaint(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR);
        this._nonPickableChartNode.addChild(this._borderNode);
        this._xAxisOfGraph = new ArrowNode(new Point2D.Double(10.0, 10.0), new Point2D.Double(20.0, 20.0), 9.0, 7.0, 1.0);
        this._xAxisOfGraph.setStroke(AXES_STROKE);
        this._xAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
        this._xAxisOfGraph.setPaint(AXES_LINE_COLOR);
        this._nonPickableChartNode.addChild(this._xAxisOfGraph);
        int n = (int)Math.round(4.2);
        this._xAxisTickMarks = new ArrayList(n);
        this._xAxisTickMarkLabels = new ArrayList(n);
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        for (int i = 0; i < n; ++i) {
            pPath = new PPath();
            pPath.setStroke(TICK_MARK_STROKE);
            pPath.setStrokePaint(TICK_MARK_COLOR);
            this._xAxisTickMarks.add(pPath);
            this._nonPickableChartNode.addChild(pPath);
            pText = new PText(decimalFormat.format(i));
            pText.setFont(TICK_MARK_LABEL_FONT);
            this._xAxisTickMarkLabels.add(pText);
            this._nonPickableChartNode.addChild(pText);
        }
        this._yAxisTickMarks = new ArrayList(2);
        PPath pPath2 = new PPath();
        pPath2.setStroke(TICK_MARK_STROKE);
        pPath2.setStrokePaint(TICK_MARK_COLOR);
        this._yAxisTickMarks.add(pPath2);
        this._nonPickableChartNode.addChild(pPath2);
        pPath = new PPath();
        pPath.setStroke(TICK_MARK_STROKE);
        pPath.setStrokePaint(TICK_MARK_COLOR);
        this._yAxisTickMarks.add(pPath);
        this._nonPickableChartNode.addChild(pPath);
        this._yAxisTickMarkLabels = new ArrayList(2);
        pText = new PText();
        pText.setFont(TICK_MARK_LABEL_FONT);
        this._yAxisTickMarkLabels.add(pText);
        this._nonPickableChartNode.addChild(pText);
        PText pText2 = new PText();
        pText2.setFont(TICK_MARK_LABEL_FONT);
        this._yAxisTickMarkLabels.add(pText2);
        this._nonPickableChartNode.addChild(pText2);
        this._xAxisLabel = new PText(NuclearPhysicsStrings.DECAY_TIME_CHART_X_AXIS_LABEL + " (" + NuclearPhysicsStrings.DECAY_TIME_UNITS + ")");
        this._xAxisLabel.setFont(SMALL_LABEL_FONT);
        this._nonPickableChartNode.addChild(this._xAxisLabel);
        this._yAxisLabel = new HTMLNode(NuclearPhysicsStrings.DECAY_TIME_CHART_LABEL_ATOMIC_WEIGHT);
        this._yAxisLabel.setFont(SMALL_LABEL_FONT);
        this._yAxisLabel.rotate(4.71238898038469);
        this._nonPickableChartNode.addChild(this._yAxisLabel);
        this._timeDisplay = new TimeDisplayNode();
        this._timeDisplay.setTime(0.0);
        this._nonPickableChartNode.addChild(this._timeDisplay);
        this._decayTimeLabel = new PText(NuclearPhysicsStrings.DECAY_TIME_LABEL);
        this._decayTimeLabel.setFont(SMALL_LABEL_FONT);
        this._nonPickableChartNode.addChild(this._decayTimeLabel);
        this._exponentialTimeLine = new LogarithmicTimeLineNode();
        this._nonPickableChartNode.addChild(this._exponentialTimeLine);
        this._halfLifeMarkerLine = new PPath();
        this._halfLifeMarkerLine.setStroke(HALF_LIFE_LINE_STROKE);
        this._halfLifeMarkerLine.setStrokePaint(HALF_LIFE_LINE_COLOR);
        this._halfLifeMarkerLine.setPaint(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR);
        this._nonPickableChartNode.addChild(this._halfLifeMarkerLine);
        this._halfLifeLabel = new PText(NuclearPhysicsStrings.HALF_LIFE_LABEL);
        this._halfLifeLabel.setFont(HALF_LIFE_FONT);
        this._halfLifeLabel.setTextPaint(HALF_LIFE_TEXT_COLOR);
        this._nonPickableChartNode.addChild(this._halfLifeLabel);
        this._halfLifeInfinityText = new PText(NuclearPhysicsStrings.INFINITY_SYMBOL);
        this._halfLifeInfinityText.setFont(HALF_LIFE_FONT);
        this._halfLifeInfinityText.setTextPaint(HALF_LIFE_TEXT_COLOR);
        this._nonPickableChartNode.addChild(this._halfLifeInfinityText);
        this._resetButtonNode = new PhetButtonNode(NuclearPhysicsStrings.DECAY_TIME_CLEAR_CHART);
        this._resetButtonNode.setPickable(true);
        this._pickableChartNode.addChild(this._resetButtonNode);
        this._resetButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleNucleusAlphaDecayTimeChart.this.handleResetChartButtonPressed();
            }
        });
        this.doLayout();
    }

    private void updateBounds(Rectangle2D rectangle2D) {
        this.setTransform(new AffineTransform());
        double d = rectangle2D.getWidth() / (this._borderNode.getFullBoundsReference().width + 6.0);
        double d2 = rectangle2D.getHeight() / (this._borderNode.getFullBoundsReference().height + 6.0);
        this.transformBy(AffineTransform.getScaleInstance(d, d2));
    }

    private void doLayout() {
        PNode pNode;
        double d;
        this._usableAreaOriginX = NOMINAL_SIZE.getX() + 6.0;
        this._usableAreaOriginY = NOMINAL_SIZE.getY() + 6.0;
        this._usableWidth = NOMINAL_SIZE.getWidth() - 12.0;
        this._usableHeight = NOMINAL_SIZE.getHeight() - 12.0;
        this._msToPixelsFactor = 0.7 * this._usableWidth / 3200.0;
        this._nucleusNodeRadius = this._usableHeight * 0.15 / 2.0;
        this._graphOriginX = this._exponentialMode ? this._usableAreaOriginX + 0.22 * this._usableWidth : this._usableAreaOriginX + 0.27 * this._usableWidth;
        this._graphOriginY = this._usableAreaOriginY + 0.65 * this._usableHeight;
        this._borderNode.setPathTo(new RoundRectangle2D.Double(this._usableAreaOriginX, this._usableAreaOriginY, this._usableWidth, this._usableHeight, 20.0, 20.0));
        this._xAxisOfGraph.setTipAndTailLocations(new Point2D.Double(this._usableAreaOriginX + this._usableWidth - 10.0, this._graphOriginY), new Point2D.Double(this._graphOriginX, this._graphOriginY));
        for (int i = 0; i < this._xAxisTickMarks.size(); ++i) {
            PPath pPath = this._xAxisTickMarks.get(i);
            d = this._graphOriginX + 100.0 * this._msToPixelsFactor + (double)(i * 1000) * this._msToPixelsFactor;
            pPath.setPathTo(new Line2D.Double(d, this._graphOriginY, d, this._graphOriginY - 3.0));
            pNode = this._xAxisTickMarkLabels.get(i);
            double d2 = d - pNode.getWidth() / 2.0;
            pNode.setOffset(d2, this._graphOriginY);
            pPath.setVisible(!this._exponentialMode);
            pNode.setVisible(!this._exponentialMode);
        }
        this._yAxisLabel.setVisible(!this._exponentialMode);
        double d3 = this._usableAreaOriginY + this._usableHeight * 0.2;
        d = this._exponentialMode ? this._usableAreaOriginY + this._usableHeight * 0.42 : this._usableAreaOriginY + this._usableHeight * 0.5;
        pNode = this._yAxisTickMarks.get(0);
        ((PPath)pNode).setPathTo(new Line2D.Double(this._graphOriginX - 3.0, d, this._graphOriginX, d));
        PPath pPath = this._yAxisTickMarks.get(1);
        pPath.setPathTo(new Line2D.Double(this._graphOriginX - 3.0, d3, this._graphOriginX, d3));
        this.setYAxisTickMarkLabelText();
        PText pText = this._yAxisTickMarkLabels.get(0);
        pText.setOffset(this._graphOriginX - pNode.getWidth() - 1.15 * pText.getWidth(), pNode.getY() - 0.5 * pText.getHeight());
        PText pText2 = this._yAxisTickMarkLabels.get(1);
        pText2.setOffset(this._graphOriginX - pPath.getWidth() - 1.15 * pText2.getWidth(), pPath.getY() - 0.5 * pText2.getHeight());
        this._xAxisLabel.setOffset(this._graphOriginX - this._xAxisLabel.getFullBoundsReference().width / 2.0, ((PNode)this._xAxisTickMarkLabels.get(0)).getFullBoundsReference().getMaxY());
        double d4 = pPath.getY() + (pNode.getY() - pPath.getY()) / 2.0;
        double d5 = Math.min(this._yAxisTickMarkLabels.get(0).getFullBoundsReference().getMinX(), this._yAxisTickMarkLabels.get(0).getFullBoundsReference().getMinX());
        this._yAxisLabel.setScale(1.0);
        double d6 = (this._graphOriginY - this._usableAreaOriginY) * 0.75 / this._yAxisLabel.getFullBoundsReference().height;
        this._yAxisLabel.setScale(d6);
        this._yAxisLabel.setOffset(d5 - this._yAxisLabel.getFullBoundsReference().height, d4 + this._yAxisLabel.getFullBounds().height / 2.0);
        this._exponentialTimeLine.setVisible(this._exponentialMode);
        this._exponentialTimeLine.setSize((int)(this._usableWidth - this._graphOriginX - 100.0 * this._msToPixelsFactor - 5.0), (int)(this._usableHeight * 0.3));
        this._exponentialTimeLine.setOffset(this._graphOriginX + 100.0 * this._msToPixelsFactor, this._graphOriginY - this._exponentialTimeLine.getFullBounds().height);
        this.positionHalfLifeMarker();
        this._timeDisplay.setSize(this._usableWidth * 0.15, this._usableHeight * 0.35);
        this._timeDisplay.setOffset(this._usableAreaOriginX + this._usableWidth * 0.015, this._usableAreaOriginY + this._usableHeight * 0.1);
        PBounds pBounds = this._timeDisplay.getFullBoundsReference();
        this._decayTimeLabel.setOffset(pBounds.getCenterX() - this._decayTimeLabel.getFullBoundsReference().width / 2.0, pBounds.getMaxY());
        this._resetButtonNode.setOffset(pBounds.getCenterX() - this._resetButtonNode.getFullBoundsReference().width / 2.0, this._usableAreaOriginY + this._usableHeight - this._resetButtonNode.getFullBoundsReference().height - 5.0);
        this.updateNucleusNodesScale();
        this.positionCurrentNucleus();
        Iterator<PNode> iterator = this._decayedNucleusNodes.iterator();
        while (iterator.hasNext()) {
            this.positionDecayedNucleusNode((EnhancedLabeledNucleusNode)iterator.next());
        }
    }

    public void componentResized(Rectangle2D rectangle2D) {
        this.updateBounds(rectangle2D);
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        if (this._currentNucleus != null && !this._currentNucleus.getPaused()) {
            if (!this._currentNucleus.hasDecayed()) {
                if (this._undecayedNucleusNode == null) {
                    this._undecayedNucleusNode = this.createNucleusNode(this._currentNucleus);
                    this._nonPickableChartNode.addChild(this._undecayedNucleusNode);
                }
                this.positionCurrentNucleus();
                this._timeDisplay.setTime(this._currentNucleus.getAdjustedActivatedTime());
            } else if (this._undecayedNucleusNode != null) {
                EnhancedLabeledNucleusNode enhancedLabeledNucleusNode = this.createNucleusNode(this._currentNucleus);
                this._nonPickableChartNode.addChild(enhancedLabeledNucleusNode);
                enhancedLabeledNucleusNode.startFalling();
                this._decayedNucleusNodes.add(enhancedLabeledNucleusNode);
                this._nonPickableChartNode.removeChild(this._undecayedNucleusNode);
                this._undecayedNucleusNode = null;
            }
        }
        for (EnhancedLabeledNucleusNode enhancedLabeledNucleusNode : this._decayedNucleusNodes) {
            if (!enhancedLabeledNucleusNode.isFalling()) continue;
            enhancedLabeledNucleusNode.decrementFallCount();
            this.positionDecayedNucleusNode(enhancedLabeledNucleusNode);
        }
    }

    private void handleModelElementAdded(Object object) {
        if (object instanceof AlphaDecayCompositeNucleus) {
            if (this._currentNucleus != null) {
                System.err.println("Error: Got nucleusAdded event before existing nucleus removed.");
            }
            this._currentNucleus = (AlphaDecayCompositeNucleus)object;
            this._undecayedNucleusNode = this.createNucleusNode(this._currentNucleus);
            this._nonPickableChartNode.addChild(this._undecayedNucleusNode);
            this.positionHalfLifeMarker();
        }
    }

    private void handleModelElementRemoved(Object object) {
        if (object instanceof AlphaDecayCompositeNucleus) {
            if (this._currentNucleus == null) {
                System.err.println("Error: Got nucleusAdded event before existing nucleus removed.");
                return;
            }
            this._currentNucleus = null;
            if (this._undecayedNucleusNode != null) {
                this._nonPickableChartNode.removeChild(this._undecayedNucleusNode);
                this._undecayedNucleusNode = null;
            }
        }
    }

    private void handleNucleusTypeChanged() {
        this.clearDecayedNuclei();
        if (this._model.getNucleusType() == NucleusType.HEAVY_CUSTOM) {
            this._exponentialMode = true;
            this.setYAxisTickMarkLabelText();
        } else {
            this._exponentialMode = false;
        }
        this.doLayout();
    }

    private void setYAxisTickMarkLabelText() {
        String string;
        String string2;
        switch (this._model.getNucleusType()) {
            case HEAVY_CUSTOM: {
                string2 = NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL;
                string = NuclearPhysicsStrings.DECAYED_CUSTOM_NUCLEUS_CHEMICAL_SYMBOL;
                break;
            }
            case POLONIUM_211: {
                string2 = NuclearPhysicsStrings.POLONIUM_211_ISOTOPE_NUMBER;
                string = NuclearPhysicsStrings.LEAD_207_ISOTOPE_NUMBER;
                break;
            }
            default: {
                string2 = "";
                string = "";
            }
        }
        if (this._yAxisTickMarkLabels.size() >= 2) {
            this._yAxisTickMarkLabels.get(0).setText(string);
            this._yAxisTickMarkLabels.get(1).setText(string2);
        }
    }

    private void positionHalfLifeMarker() {
        double d = this._model.getHalfLife();
        double d2 = 0.0;
        if (this._exponentialMode) {
            if (d == Double.POSITIVE_INFINITY) {
                d2 = this._xAxisOfGraph.getFullBoundsReference().getMaxX();
            } else {
                d2 = (double)this._exponentialTimeLine.mapTimeToHorizPixels(d) + this._graphOriginX + 100.0 * this._msToPixelsFactor;
                d2 = Math.min(d2, this._xAxisOfGraph.getFullBoundsReference().getMaxX());
            }
        } else {
            d2 = this._graphOriginX + (100.0 + d) * this._msToPixelsFactor;
        }
        this._halfLifeMarkerLine.reset();
        this._halfLifeMarkerLine.moveTo((float)d2, (float)(this._graphOriginY + (this._usableHeight - this._graphOriginY) * 0.4));
        this._halfLifeMarkerLine.lineTo((float)d2, (float)(this._usableAreaOriginY + 0.1 * this._usableHeight));
        this._halfLifeLabel.setOffset(this._halfLifeMarkerLine.getX() - this._halfLifeLabel.getFullBoundsReference().width / 2.0, (float)(this._graphOriginY + (this._usableHeight - this._graphOriginY) * 0.5));
        if (this._xAxisLabel.getFullBoundsReference().intersects(this._halfLifeLabel.getFullBoundsReference())) {
            this._xAxisLabel.setVisible(false);
        } else {
            this._xAxisLabel.setVisible(true);
        }
        this._halfLifeInfinityText.setScale(1.0);
        if (this._halfLifeMarkerLine.getFullBoundsReference().height > 0.0 && this._halfLifeInfinityText.getFullBoundsReference().height > 0.0) {
            double d3 = this._halfLifeMarkerLine.getFullBoundsReference().height * 0.7;
            this._halfLifeInfinityText.setScale(d3 / this._halfLifeInfinityText.getFullBoundsReference().height);
        }
        this._halfLifeInfinityText.setOffset(this._halfLifeMarkerLine.getX() - this._halfLifeInfinityText.getFullBoundsReference().width, this._halfLifeMarkerLine.getFullBoundsReference().getMinY() - this._halfLifeInfinityText.getFullBoundsReference().height * 0.4);
        this._halfLifeInfinityText.setVisible(this._model.getHalfLife() == Double.POSITIVE_INFINITY);
    }

    private void updateNucleusNodesScale() {
        if (this._nucleusNodeRadius > 0.0) {
            if (this._undecayedNucleusNode != null) {
                this._undecayedNucleusNode.setScale(1.0);
                this._undecayedNucleusNode.setScale(this._nucleusNodeRadius * 2.0 / this._undecayedNucleusNode.getFullBoundsReference().height);
            }
            for (PNode pNode : this._decayedNucleusNodes) {
                pNode.setScale(1.0);
                pNode.setScale(this._nucleusNodeRadius * 2.0 / pNode.getFullBoundsReference().height);
            }
        }
    }

    private void reset() {
        this._chartCleared = false;
        this._exponentialMode = false;
        this.doLayout();
    }

    private void handleResetChartButtonPressed() {
        this.clearDecayedNuclei();
    }

    private EnhancedLabeledNucleusNode createNucleusNode(AtomicNucleus atomicNucleus) {
        EnhancedLabeledNucleusNode enhancedLabeledNucleusNode;
        switch (atomicNucleus.getNumProtons()) {
            case 84: {
                enhancedLabeledNucleusNode = new EnhancedLabeledNucleusNode("polonium-nucleus-small.png", NuclearPhysicsStrings.POLONIUM_211_ISOTOPE_NUMBER, NuclearPhysicsStrings.POLONIUM_211_CHEMICAL_SYMBOL, NuclearPhysicsConstants.POLONIUM_LABEL_COLOR);
                break;
            }
            case 83: {
                enhancedLabeledNucleusNode = new EnhancedLabeledNucleusNode("polonium-nucleus-small.png", "", NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL, NuclearPhysicsConstants.CUSTOM_NUCLEUS_LABEL_COLOR);
                break;
            }
            case 82: {
                enhancedLabeledNucleusNode = new EnhancedLabeledNucleusNode("lead-nucleus-small.png", NuclearPhysicsStrings.LEAD_207_ISOTOPE_NUMBER, NuclearPhysicsStrings.LEAD_207_CHEMICAL_SYMBOL, NuclearPhysicsConstants.LEAD_LABEL_COLOR);
                break;
            }
            case 81: {
                enhancedLabeledNucleusNode = new EnhancedLabeledNucleusNode("lead-nucleus-small.png", "", NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL, NuclearPhysicsConstants.CUSTOM_NUCLEUS_POST_DECAY_LABEL_COLOR);
                break;
            }
            default: {
                assert (false);
                throw new InvalidParameterException("Unrecognized nucleus type.");
            }
        }
        if (this._nucleusNodeRadius > 0.0) {
            enhancedLabeledNucleusNode.setScale(this._nucleusNodeRadius * 2.0 / enhancedLabeledNucleusNode.getFullBoundsReference().height);
        }
        return enhancedLabeledNucleusNode;
    }

    private void positionCurrentNucleus() {
        if (this._currentNucleus == null || this._currentNucleus.hasDecayed() || this._currentNucleus.getPaused()) {
            return;
        }
        double d = this._usableAreaOriginY + this._usableHeight * 0.2 - this._nucleusNodeRadius;
        double d2 = this._exponentialMode ? (double)this._exponentialTimeLine.mapTimeToHorizPixels(this._currentNucleus.getAdjustedActivatedTime()) + this._graphOriginX + 100.0 * this._msToPixelsFactor - this._nucleusNodeRadius : this._graphOriginX + (this._currentNucleus.getAdjustedActivatedTime() + 100.0) * this._msToPixelsFactor - this._nucleusNodeRadius;
        this._undecayedNucleusNode.setOffset(d2, d);
    }

    private void positionDecayedNucleusNode(EnhancedLabeledNucleusNode enhancedLabeledNucleusNode) {
        double d;
        double d2 = this._exponentialMode ? 0.42 : 0.5;
        double d3 = this._exponentialMode ? (double)this._exponentialTimeLine.mapTimeToHorizPixels(this._currentNucleus.getAdjustedActivatedTime()) + this._graphOriginX + 100.0 * this._msToPixelsFactor - this._nucleusNodeRadius : this._graphOriginX + (this._currentNucleus.getAdjustedActivatedTime() + 100.0) * this._msToPixelsFactor - this._nucleusNodeRadius;
        if (enhancedLabeledNucleusNode.getFallCount() != 0) {
            double d4 = this._usableHeight * (d2 - 0.2);
            d = this._usableAreaOriginY + this._usableHeight * 0.2 + d4 * (1.0 - (double)enhancedLabeledNucleusNode.getFallCount() / 5.0) - this._nucleusNodeRadius;
        } else {
            d = this._usableAreaOriginY + this._usableHeight * d2 - this._nucleusNodeRadius;
        }
        enhancedLabeledNucleusNode.setOffset(d3, d);
    }

    private void clearDecayedNuclei() {
        for (EnhancedLabeledNucleusNode enhancedLabeledNucleusNode : this._decayedNucleusNodes) {
            this._nonPickableChartNode.removeChild(enhancedLabeledNucleusNode);
        }
        this._decayedNucleusNodes.clear();
    }

    static {
        HALF_LIFE_TEXT_COLOR = HALF_LIFE_LINE_COLOR = new Color(238, 0, 0);
        HALF_LIFE_FONT = new PhetFont(1, 16);
        TIME_LINE_BASE_COLOR = Color.BLUE;
    }

    private class EnhancedLabeledNucleusNode
    extends LabeledNucleusImageNode {
        private int _fallCount;

        public EnhancedLabeledNucleusNode(String string, String string2, String string3, Color color) {
            super(string, string2, string3, color);
            this._fallCount = 0;
        }

        protected void startFalling() {
            this._fallCount = 5;
        }

        protected boolean isFalling() {
            return this._fallCount != 0;
        }

        protected void decrementFallCount() {
            if (this._fallCount > 0) {
                --this._fallCount;
            }
        }

        protected int getFallCount() {
            return this._fallCount;
        }
    }

    private class LogarithmicTimeLineNode
    extends PNode {
        private PPath _outline;
        private double _timeToPositionMultiplier;
        private int _width = 0;
        private int _height = 0;
        private ArrayList<PhetPPath> _timeLineSections = new ArrayList();
        private double[] _timeLineSectionValues = new double[]{1000.0, 60000.0, 3600000.0, 8.64E7, 3.16E10, 3.16E13, 3.16E16, 3.16E19, 3.2E22};
        private ArrayList<PText> _sectionLabels = new ArrayList();

        public LogarithmicTimeLineNode() {
            this._outline = new PPath();
            this._outline.setStrokePaint(Color.RED);
            this._outline.setVisible(false);
            this.addChild(this._outline);
            for (int i = 0; i < this._timeLineSectionValues.length; ++i) {
                PhetPPath phetPPath = new PhetPPath();
                this.addChild(phetPPath);
                this._timeLineSections.add(phetPPath);
            }
            PText pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_MILLISECONDS);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
            pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_SECONDS);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
            pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_MINUTES);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
            pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_HOURS);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
            pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_DAYS);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
            pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_YRS);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
            pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_MILLENIA);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
            pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_MILLION_YRS);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
            pText = new PText();
            pText.setText(NuclearPhysicsStrings.TIME_GRAPH_UNITS_BILLION_YRS);
            pText.setFont(SMALL_LABEL_FONT);
            this._sectionLabels.add(pText);
            this.addChild(pText);
        }

        public void setSize(int n, int n2) {
            if (n < 0 || n2 < 0) {
                return;
            }
            this._width = n;
            this._height = n2;
            this.update();
        }

        private void update() {
            this._timeToPositionMultiplier = (double)this._width / Math.log(3.2E22);
            double d = (double)this._height * 0.5;
            PText pText = this._sectionLabels.get(0);
            pText.setScale(1.0);
            double d2 = d / pText.getHeight();
            this._outline.setPathToRectangle(0.0f, 0.0f, this._width, this._height);
            for (int i = 0; i < this._timeLineSections.size(); ++i) {
                PhetPPath phetPPath = this._timeLineSections.get(i);
                float f = i == 0 ? 0.0f : (float)this._timeLineSections.get(i - 1).getFullBounds().getMaxX();
                float f2 = (float)this.mapTimeToHorizPixels(this._timeLineSectionValues[i]) - f;
                float f3 = (float)((double)this._height * 0.5);
                phetPPath.setPathToRectangle(0.0f, 0.0f, f2, f3);
                phetPPath.setOffset(f, 0.0);
                phetPPath.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, f2, f3, TIME_LINE_BASE_COLOR));
                if (this._sectionLabels.size() <= i) continue;
                PText pText2 = this._sectionLabels.get(i);
                pText2.setScale(1.0);
                pText2.setScale(d2);
                pText2.setOffset(f + 4.0f, phetPPath.getFullBounds().getMaxY());
            }
        }

        public int mapTimeToHorizPixels(double d) {
            int n = d < 0.0 ? 0 : (int)Math.round(this._timeToPositionMultiplier * Math.log(d + 1.0));
            return n;
        }
    }

    private class TimeDisplayNode
    extends PNode {
        private final Color BACKGROUND_COLOR = new Color(255, 255, 255);
        private final Font TIME_FONT = new PhetFont(1, 26);
        private final double MILLISECONDS_PER_SECOND = 1000.0;
        private final double MILLISECONDS_PER_MINUTE = 60000.0;
        private final double MILLISECONDS_PER_HOUR = 3600000.0;
        private final double MILLISECONDS_PER_DAY = 8.64E7;
        private final double MILLISECONDS_PER_YEAR = 3.16E10;
        private final double MILLISECONDS_PER_MILLENIUM = 3.16E13;
        private final double MILLISECONDS_PER_MILLION_YEARS = 3.16E16;
        private final double MILLISECONDS_PER_BILLION_YEARS = 3.16E19;
        private final double MILLISECONDS_PER_TRILLION_YEARS = 3.16E22;
        private final double MILLISECONDS_PER_QUADRILLION_YEARS = 3.16E25;
        private final int EXPONENT_SCALE = 80;
        private double _readoutWidth;
        private double _readoutHeight;
        private PPath _background;
        private RoundRectangle2D _backgroundShape;
        private double _currentTimeInMilliseconds;
        private HTMLNode _timeText;
        private HTMLNode _unitsText;
        private PText _spaceText;
        private HTMLNode _dummyTextNormal;
        private HTMLNode _dummyTextExponential;
        private DecimalFormat _timeFormatterNoDecimals = new DecimalFormat("##0");
        private DecimalFormat _timeFormatterOneDecimal = new DecimalFormat("##0.0");
        private ConstantPowerOfTenNumberFormat _thousandsFormatter = new ConstantPowerOfTenNumberFormat("0", 3, 80);
        private ConstantPowerOfTenNumberFormat _millionsFormatter = new ConstantPowerOfTenNumberFormat("0", 6, 80);
        private ConstantPowerOfTenNumberFormat _billionsFormatter = new ConstantPowerOfTenNumberFormat("0", 9, 80);
        private ConstantPowerOfTenNumberFormat _trillionsFormatter = new ConstantPowerOfTenNumberFormat("0", 12, 80);

        TimeDisplayNode() {
            this._readoutWidth = SingleNucleusAlphaDecayTimeChart.this._usableWidth * 0.22;
            this._readoutHeight = SingleNucleusAlphaDecayTimeChart.this._usableHeight * 0.2;
            this._backgroundShape = new RoundRectangle2D.Double(0.0, 0.0, this._readoutWidth, this._readoutHeight, 8.0, 8.0);
            this._background = new PPath(this._backgroundShape);
            this._background.setPaint(this.BACKGROUND_COLOR);
            this.addChild(this._background);
            this._timeText = new HTMLNode();
            this._timeText.setFont(this.TIME_FONT);
            this.addChild(this._timeText);
            this._spaceText = new PText(" ");
            this._spaceText.setFont(this.TIME_FONT);
            this.addChild(this._spaceText);
            this._unitsText = new HTMLNode();
            this._unitsText.setFont(this.TIME_FONT);
            this.addChild(this._unitsText);
            this._dummyTextNormal = new HTMLNode(this._timeFormatterNoDecimals.format(9999L));
            this._dummyTextNormal.setFont(this.TIME_FONT);
            this._dummyTextExponential = new HTMLNode(this._trillionsFormatter.format(9.99E14));
            this._dummyTextExponential.setFont(this.TIME_FONT);
        }

        public void setSize(double d, double d2) {
            this._readoutWidth = d;
            this._readoutHeight = d2;
            this._backgroundShape.setFrame(0.0, 0.0, this._readoutWidth, this._readoutHeight);
            this._background.setPathTo(this._backgroundShape);
            this.updateTextScaling();
            this.updateTimeDisplay();
        }

        private void updateTextScaling() {
            double d;
            double d2;
            this._timeText.setScale(1.0);
            this._unitsText.setScale(1.0);
            this._dummyTextExponential.setScale(1.0);
            this._dummyTextNormal.setScale(1.0);
            this._spaceText.setScale(1.0);
            double d3 = this._readoutHeight * 0.9;
            double d4 = this._readoutWidth * 0.9;
            double d5 = 1.0;
            if (this._currentTimeInMilliseconds > 3.16E13) {
                d2 = this._dummyTextExponential.getFullBoundsReference().width + this._unitsText.getFullBoundsReference().width;
                d = this._dummyTextExponential.getFullBoundsReference().height;
            } else {
                d2 = this._dummyTextNormal.getFullBoundsReference().width + this._unitsText.getFullBoundsReference().width;
                d = this._dummyTextNormal.getFullBoundsReference().height;
            }
            if (d2 > d4) {
                d5 = d4 / d2;
            }
            if (d > d3) {
                if (d3 / d < d5) {
                    d5 = d3 / d;
                }
                d5 = d4 / d2;
            }
            if (d5 != 0.0) {
                this._timeText.setScale(d5);
                this._spaceText.setScale(d5);
                this._dummyTextNormal.setScale(d5);
                this._dummyTextExponential.setScale(d5);
                this._unitsText.setScale(d5);
            }
        }

        public void setTime(double d) {
            this._currentTimeInMilliseconds = d;
            if (d < 1000.0) {
                this._timeText.setHTML(this._timeFormatterNoDecimals.format(d));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_MILLISECONDS);
            } else if (d < 60000.0) {
                this._timeText.setHTML(this._timeFormatterOneDecimal.format(d / 1000.0));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_SECONDS);
            } else if (d < 3600000.0) {
                this._timeText.setHTML(this._timeFormatterOneDecimal.format(d / 60000.0));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_MINUTES);
            } else if (d < 8.64E7) {
                this._timeText.setHTML(this._timeFormatterOneDecimal.format(d / 3600000.0));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_HOURS);
            } else if (d < 3.16E10) {
                this._timeText.setHTML(this._timeFormatterNoDecimals.format(d / 8.64E7));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_DAYS);
            } else if (d < 3.16E13) {
                this._timeText.setHTML(this._timeFormatterNoDecimals.format(d / 3.16E10));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_YEARS);
            } else if (d < 3.16E16) {
                this._timeText.setHTML(this._thousandsFormatter.format(d / 3.16E10));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_YRS);
            } else if (d < 3.16E19) {
                this._timeText.setHTML(this._millionsFormatter.format(d / 3.16E10));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_YRS);
            } else if (d < 3.16E22) {
                this._timeText.setHTML(this._billionsFormatter.format(d / 3.16E10));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_YRS);
            } else if (d < 3.16E25) {
                this._timeText.setHTML(this._trillionsFormatter.format(d / 3.16E10));
                this._unitsText.setHTML(NuclearPhysicsStrings.READOUT_UNITS_YRS);
            } else {
                this._timeText.setHTML("\u221e");
                this._unitsText.setHTML("");
            }
            this.updateTextScaling();
            this.updateTimeDisplay();
        }

        private void updateTimeDisplay() {
            double d;
            double d2;
            if (this._currentTimeInMilliseconds < 3.16E13) {
                d2 = this._readoutWidth / 2.0 - (this._dummyTextNormal.getFullBoundsReference().width + this._spaceText.getFullBoundsReference().width + this._unitsText.getFullBoundsReference().width) / 2.0;
                d2 += this._dummyTextNormal.getFullBoundsReference().width - this._timeText.getFullBoundsReference().width;
                d = this._readoutHeight / 2.0 - this._dummyTextNormal.getFullBoundsReference().height / 2.0;
            } else if (this._unitsText.getHTML() != "") {
                d2 = this._readoutWidth / 2.0 - (this._dummyTextExponential.getFullBoundsReference().width + this._spaceText.getFullBoundsReference().width + this._unitsText.getFullBoundsReference().width) / 2.0;
                d2 += this._dummyTextExponential.getFullBoundsReference().width - this._timeText.getFullBoundsReference().width;
                d = this._readoutHeight / 2.0 - this._dummyTextExponential.getFullBoundsReference().height / 2.0;
            } else {
                d2 = this._readoutWidth / 2.0 - this._timeText.getFullBoundsReference().width / 2.0;
                d = this._readoutHeight / 2.0 - this._timeText.getFullBoundsReference().height / 2.0;
            }
            this._timeText.setOffset(d2, d);
            this._spaceText.setOffset(d2 + this._timeText.getFullBoundsReference().width, d);
            this._unitsText.setOffset(d2 + this._timeText.getFullBoundsReference().width + this._spaceText.getFullBoundsReference().width, this._timeText.getFullBoundsReference().getMaxY() - this._unitsText.getFullBoundsReference().height);
        }
    }
}

