/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.util.MutablePoints;
import edu.umd.cs.piccolox.util.Points;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class XYArray
implements MutablePoints,
Cloneable {
    private double[] points = null;
    private int numPoints = 0;

    public XYArray(int n) {
        this.initPoints(null, n);
    }

    public XYArray() {
        this(0);
    }

    public int getPointCount() {
        return this.numPoints;
    }

    private int normalize(int n) {
        if (n >= this.numPoints) {
            throw new IllegalArgumentException("The point index " + n + " is not below " + this.numPoints);
        }
        if (n < 0) {
            return this.numPoints + n;
        }
        return n;
    }

    public double getX(int n) {
        return this.points[this.normalize(n) * 2];
    }

    public double getY(int n) {
        return this.points[this.normalize(n) * 2 + 1];
    }

    public void setPoint(int n, double d, double d2) {
        int n2 = this.normalize(n);
        this.points[n2 * 2] = d;
        this.points[n2 * 2 + 1] = d2;
    }

    public void transformPoints(AffineTransform affineTransform) {
        affineTransform.transform(this.points, 0, this.points, 0, this.numPoints);
    }

    public Rectangle2D getBounds(Rectangle2D rectangle2D) {
        int n = 0;
        if (rectangle2D.isEmpty() && this.getPointCount() > 0) {
            rectangle2D.setRect(this.getX(n), this.getY(n), 1.0, 1.0);
            ++n;
        }
        while (n < this.getPointCount()) {
            rectangle2D.add(this.getX(n), this.getY(n));
            ++n;
        }
        return rectangle2D;
    }

    public static double[] initPoints(double[] dArray, int n, double[] dArray2) {
        double[] dArray3 = dArray == null || n * 2 > dArray.length ? new double[n * 2] : dArray;
        if (dArray2 != null && dArray3 != dArray2) {
            System.arraycopy(dArray2, 0, dArray3, 0, Math.min(dArray2.length, n * 2));
        }
        return dArray3;
    }

    private void initPoints(double[] dArray, int n) {
        this.points = XYArray.initPoints(dArray, n, this.points);
        this.numPoints = dArray == null ? 0 : dArray.length / 2;
    }

    public void addPoints(int n, Points points, int n2, int n3) {
        int n4 = n3 < 0 ? points.getPointCount() + n3 + 1 : n3;
        int n5 = this.numPoints + n4 - n2;
        this.points = XYArray.initPoints(this.points, n5, this.points);
        int n6 = n * 2;
        int n7 = (n + n4 - n2) * 2;
        int n8 = (this.numPoints - n) * 2;
        System.arraycopy(this.points, n6, this.points, n7, n8);
        this.numPoints = n5;
        if (points != null) {
            int n9 = 0;
            for (int i = n2; i < n4; ++i) {
                this.setPoint(n + n9, points.getX(i), points.getY(i));
                ++n9;
            }
        }
    }

    public void addPoints(int n, Points points) {
        this.addPoints(n, points, 0, points.getPointCount());
    }

    public void appendPoints(Points points) {
        this.addPoints(this.numPoints, points);
    }

    public void addPoint(int n, double d, double d2) {
        this.addPoints(n, null, 0, 1);
        this.setPoint(n, d, d2);
    }

    public void removePoints(int n, int n2) {
        int n3 = Math.min(n2, this.numPoints - n);
        if (n3 > 0) {
            System.arraycopy(this.points, (n + n3) * 2, this.points, n * 2, (this.numPoints - (n + n3)) * 2);
            this.numPoints -= n3;
        }
    }

    public Object clone() {
        XYArray xYArray = null;
        try {
            xYArray = (XYArray)super.clone();
            xYArray.points = XYArray.initPoints(xYArray.points, this.numPoints, this.points);
            xYArray.numPoints = this.numPoints;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return xYArray;
    }
}

